#include <System/DAQBuilderRawAudioSystem.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            RawAudioSystem::_finalize()
  {
    ::close(_deviceFD);
  }

  void              RawAudioSystem::_open()
     throw(IOException *)
  {
    _deviceFD = ::open(_deviceName.c_str(),O_WRONLY);
    DInt aFormat = AFMT_S16_LE;
    ::ioctl(_deviceFD,SNDCTL_DSP_SETFMT,&aFormat);
    aFormat      = 1;
    ::ioctl(_deviceFD,SNDCTL_DSP_STEREO,&aFormat);
    aFormat      = 44100;
    ::ioctl(_deviceFD,SNDCTL_DSP_SPEED,&aFormat);
  }
  const  DString                  RawAudioSystem::toString() const 
  {
    DString aString ;//= _toStringHeader();
    return aString;
  }
  void  RawAudioSystem::mark()
  { 
    if(markSupported())
      _soundSource -> mark();
  }                       
  DBool RawAudioSystem::markSupported()
  {
    return _soundSource -> markSupported();
  }              
  DULong RawAudioSystem::play( DLong numLoop  )
    throw(Exception*)
  {
    DULong totalRead = 0;
    if(numLoop <= 0) 
      numLoop = 1 ;
    DLong i ;
    for( i = 0 ; i < numLoop ; i++ )
    {
     if(numLoop!=1)
      mark();
    DULong numRead = 0;
    do{
      DByte * aBuf = new DByte[ _readSize ];
      numRead = _soundSource -> read( aBuf , _readSize );
      ::write( _deviceFD, aBuf, numRead );
      totalRead += numRead;
      delete [] aBuf;
     }while( numRead != 0 );
     if(numLoop!=1)
      reset();
    }
    return totalRead;
  }
  void  RawAudioSystem::reset()                      
    throw(IOException*)
  {
    _soundSource -> reset();
  }

  DLong RawAudioSystem::skip( DLong     nSkip)       
    throw(IOException*)
  {
    return     _soundSource -> skip(nSkip);
  }

  void  RawAudioSystem::close()
    throw(IOException*)
  {
    _soundSource -> close();
    ::close(_deviceFD);
  }
  RawAudioSystem::RawAudioSystem( InputStream *    soundSource, 
	       const DULong&     readSize,
				  const DString&    deviceName)
    :AudioSystem(soundSource,readSize),
     _deviceName(deviceName)
  {
    _setType();
    _setParentClasses();
    _open();
  }
  RawAudioSystem::RawAudioSystem( const RawAudioSystem& right ) 
    :AudioSystem(*((AudioSystem*)&right)),
     _deviceName(right._deviceName)

  {
    _setType();
    _setParentClasses();
    _open();
  }
  RawAudioSystem::~RawAudioSystem()
  {
    _finalize();
  }
  RawAudioSystem& RawAudioSystem::operator   =(const RawAudioSystem & right )
  {
    *((AudioSystem*)this) =       *((AudioSystem*)&right);
    _deviceName    =right._deviceName;
    _open();
    return *this;
  }
  DBool   RawAudioSystem::operator   ==(const RawAudioSystem & right ) const 
  {
    DBool aBool = *((AudioSystem*)this) ==  *((AudioSystem*)&right);
    aBool      |= _deviceName      ==  right._deviceName;
    aBool      |= _deviceFD        ==  right._deviceFD;
    return aBool;
  }
  DBool   RawAudioSystem::operator   !=(const RawAudioSystem & right ) const 
  {
    DBool aBool = *((AudioSystem*)this) !=  *((AudioSystem*)&right);
    aBool      |= _deviceName      !=  right._deviceName;
    aBool      |= _deviceFD        !=  right._deviceFD;
    return aBool;
  }
}
