#ifndef __DAQBuilderRawAudioSystem_HH__
#define __DAQBuilderRawAudioSystem_HH__
#include <System/DAQBuilderAudioSystem.hh>
#include <esd.h>
namespace DAQBuilder
{
  class RawAudioSystem : public AudioSystem
  {
  protected:
    DString           _deviceName;
    FileDescriptor    _deviceFD;
  protected:
    void              _setType();
    void              _setParentClasses();
    void              _finalize();
  protected:
    void              _open()
      throw(IOException*);
  public:
    const  DString           toString() const ;
  public:
    virtual void  mark();
    virtual DBool markSupported();
    virtual DULong play( DLong numLoop = -1 )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    RawAudioSystem( InputStream *     _inputStream,
		    const DULong&     _readSize  = 1024 ,
		    const DString&    _deviceName = "/dev/dsp"
		    );
    RawAudioSystem( const RawAudioSystem& right );
    ~RawAudioSystem();
  public:    
    RawAudioSystem& operator   =(const RawAudioSystem & right );
    virtual DBool   operator   ==(const RawAudioSystem& right ) const ;
    virtual DBool   operator   !=(const RawAudioSystem& right ) const ;
  };
  inline void   RawAudioSystem::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("AudioSystem");
  }
  inline void   RawAudioSystem::_setType()
  {
    this -> _type = "RawAudioSystem";
  }
}
#endif
