#include <System/DAQBuilderRunRegistry.hh>
#include <Run/DAQBuilderRun.hh>

namespace DAQBuilder
{
  std::map<DString,Run>  RunRegistry::_actionTable;

  void              RunRegistry::unbind( const DString& key )
    throw( RunNotFoundException * )
  {
    if((RunRegistry::_actionTable).find(key)  
       == (RunRegistry::_actionTable).end()){
      RunNotFoundException * e = new RunNotFoundException("Run not found : "+key);
      e -> insert("Location","RunRegistry::unbind(const DString& key )");
      throw e;
	}
    (RunRegistry::_actionTable).erase(key);
  }
  Run& RunRegistry::lookUp( const DString& key )
    throw( RunNotFoundException * )
  {
    std::map<DString,Run>::iterator iter 
      = (RunRegistry::_actionTable).find(key);
    if(  iter == (RunRegistry::_actionTable).end()){
      RunNotFoundException * e = new RunNotFoundException("Run not found : "+key);
      e -> insert("Location","RunRegistry::lookUp(key)");
      throw e;
    }
    return (Run&)(iter -> second);
  }
  void              RunRegistry::bind( const DString& name , Run& action )
    throw( SameNameBindedException * )
  {
    if((RunRegistry::_actionTable).find(name)  
       != (RunRegistry::_actionTable).end()){
      SameNameBindedException * e = new SameNameBindedException("Run Already Inserted : "+ name);
      e -> insert("Location","RunRegistry::bind( const DString&  , Run&  )");
      throw e;
	}
    (RunRegistry::_actionTable).insert(std::pair<DString,Run>(name,action));
  }
 void              RunRegistry::rebind( const DString& name , Run& action )
   throw( RunNotFoundException * )
  {
    std::map<DString,Run>::iterator iter 
      = (RunRegistry::_actionTable).find(name)  ;
       if( iter  == (RunRegistry::_actionTable).end()){
      RunNotFoundException * e = new RunNotFoundException("Run not found: "+name);
      e -> insert("Location","RunRegistry::rebind( const DString& , Run&)");
      throw e;
	}
       unbind(name);
       bind(name,action);
  }
  void              RunRegistry::clear()
  {
    (RunRegistry::_actionTable).clear();
  }
  RunRegistry::RunRegistry()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  void              RunRegistry::shutdown()
   {
    for( std::map< DString , Run> :: iterator iter= (RunRegistry::_actionTable).begin() ; 
	 iter != (RunRegistry::_actionTable).end() ; 
	 iter++)
      {
	Run& targetRun = (iter -> second);
	if(targetRun.isRunning())
	   targetRun.pause();
	targetRun.shutdown();
      }
   }
  RunRegistry::RunRegistry( const RunRegistry& right )
    :Object(*((Object*)&right))
  {
  }
  RunRegistry::~RunRegistry()
  {
    _finalize();
  }
  RunRegistry& RunRegistry::operator =(const RunRegistry& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  const DString RunRegistry::toString() const 
  {
    DString aString ;//= _toStringHeader();
    for( std::map< DString , Run> :: iterator iter= (RunRegistry::_actionTable).begin() ; 
	 iter != (RunRegistry::_actionTable).end() ; 
	 iter++)
      {
	aString            += "( ";
	aString            += iter -> first;
	aString            += " , ";
	aString            += (iter -> second).toString();
	aString            += " )\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
  StringList        RunRegistry::getBindedRunList()
      throw( RunNotFoundException * )
  {
    StringList aStringList;
    for( std::map< DString , Run> :: iterator iter= (RunRegistry::_actionTable).begin() ; 
	 iter != (RunRegistry::_actionTable).end() ; 
	 iter++)
      {
	aStringList.push_back(iter -> first);
      }
    return aStringList;
  }
}
