#ifndef __DAQBuilderRunRegistry_HH__
#define __DAQBuilderRunRegistry_HH__
#include <Exception/DAQBuilderRunNotFoundException.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>

namespace DAQBuilder
{
  class Run;
  class RunRegistry : public Object
  {
  private:
    static std::map<DString,Run>  _actionTable;
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    static void                bind( const DString& name , Run& object )
      throw( SameNameBindedException * );
    static void                rebind( const DString& name , Run& object )
      throw( RunNotFoundException * );
    static void                unbind( const DString& name )
      throw( RunNotFoundException * );
    static void                clear();
    static Run&           lookUp( const DString & name )
      throw( RunNotFoundException * );
    static StringList        getBindedRunList()
      throw( RunNotFoundException * );
    static void              shutdown();
  public :
    RunRegistry();
    RunRegistry( const RunRegistry& right );
    ~RunRegistry();
  public:    
    RunRegistry& operator   =(const RunRegistry & right );
    
  };
  inline void   RunRegistry::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   RunRegistry::_setType()
  {
    this -> _type = "RunRegistry";
  }
}
#endif
