#include <System/DAQBuilderSerializableObjectLoader.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <Exception/DAQBuilderObjectNotFoundException.hh>

namespace DAQBuilder
{
  std::map<DString,SerializableObject*>  SerializableObjectLoader::_serializableObjectTable;

  void              SerializableObjectLoader::deleteFromTable( const DString& key )
       throw(ObjectNotFoundException *)
  {
    if((SerializableObjectLoader::_serializableObjectTable).find(key)  
       == (SerializableObjectLoader::_serializableObjectTable).end()){
      ObjectNotFoundException * e = new ObjectNotFoundException("ObjectNotFound : "+key);
      e -> insert("Location","SerializableObjectLoader::insertToTable( SerializableObject *& object  )");
      throw e;
	}
    (SerializableObjectLoader::_serializableObjectTable).erase(key);
  }
  SerializableObject* SerializableObjectLoader::getObject( const DString& key )
       throw(ObjectNotFoundException *)
  {
    std::map<DString,SerializableObject*>::const_iterator iter 
      = (SerializableObjectLoader::_serializableObjectTable).find(key);
    if(  iter == (SerializableObjectLoader::_serializableObjectTable).end()){
      ObjectNotFoundException * e = new ObjectNotFoundException("ObjectNotFound : "+key);
      e -> insert("Location","SerializableObjectLoader::getObject(key)");
      throw e;
    }
    return (SerializableObject*)(iter -> second -> clone());
  }
  void              SerializableObjectLoader::insertToTable( SerializableObject * object  )
       throw(SameNameBindedException *)
  {
    if((SerializableObjectLoader::_serializableObjectTable).find(object -> getType())  
       != (SerializableObjectLoader::_serializableObjectTable).end()){
      SameNameBindedException * e = new SameNameBindedException("Object Already Inserted : "+ object->getType());
      e -> insert("Location","SerializableObjectLoader::insertToTable( SerializableObject *& object  )");
      throw e;
	}
    (SerializableObjectLoader::_serializableObjectTable).insert(std::pair<DString,SerializableObject*>(object->getType(),object));
  }
  void              SerializableObjectLoader::clearTable()
  {
    for( std::map< DString , SerializableObject *> ::iterator iter = (SerializableObjectLoader::_serializableObjectTable).begin();
	 iter                                                     != (SerializableObjectLoader::_serializableObjectTable).end();
	 iter++)
      deleteObject((Object*&)iter->second);
    (SerializableObjectLoader::_serializableObjectTable).clear();
  }
  SerializableObjectLoader::SerializableObjectLoader()
    :Object()
  {
    _setType();
    _setParentClasses();
  }
  SerializableObjectLoader::SerializableObjectLoader( const SerializableObjectLoader& right )
    :Object(*((Object*)&right))
  {
  }
  SerializableObjectLoader::SerializableObjectLoader( SerializableObject  * object )
   :Object()
  {
    _setType();
    _setParentClasses();
   SerializableObjectLoader::insertToTable(object);
  }
  SerializableObjectLoader::~SerializableObjectLoader()
  {
    _finalize();
  }
  SerializableObjectLoader& SerializableObjectLoader::operator =(const SerializableObjectLoader& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  DBool   SerializableObjectLoader::operator   ==(const SerializableObjectLoader & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   SerializableObjectLoader::operator   !=(const SerializableObjectLoader & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  const DString SerializableObjectLoader::toString() const 
  {
    DString aString ;//= _toStringHeader();
    for( std::map< DString , SerializableObject *> :: iterator iter= (SerializableObjectLoader::_serializableObjectTable).begin() ; 
	 iter != (SerializableObjectLoader::_serializableObjectTable).end() ; 
	 iter++)
      {
	aString            += "( ";
	aString            += iter -> first;
	aString            += " , ";
	aString            += iter -> second -> toString();
	aString            += " )\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
}
