#ifndef __DAQBuilderSerializableObjectLoader_HH__
#define __DAQBuilderSerializableObjectLoader_HH__
#include <DAQBuilderSerializableObject.hh>
#include <Exception/DAQBuilderObjectNotFoundException.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>

namespace DAQBuilder
{
  class SerializableObjectLoader : public Object 
  {
  private:
    static std::map<DString,SerializableObject*>  _serializableObjectTable;
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    static void                deleteFromTable( const DString& key )
       throw(ObjectNotFoundException *);
    static void                insertToTable( SerializableObject * object  )
       throw(SameNameBindedException *);
    static void                clearTable();
    static SerializableObject* getObject( const DString & key )
       throw(ObjectNotFoundException *);
  public :
    SerializableObjectLoader();
    SerializableObjectLoader( const SerializableObjectLoader& right );
    SerializableObjectLoader( SerializableObject  * object );
    ~SerializableObjectLoader();
  public:    
    SerializableObjectLoader& operator   =(const SerializableObjectLoader & right );
    virtual DBool   operator   ==(const SerializableObjectLoader& right ) const ;
    virtual DBool   operator   !=(const SerializableObjectLoader& right ) const ;
  };
  inline void   SerializableObjectLoader::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   SerializableObjectLoader::_setType()
  {
    this -> _type = "SerializableObjectLoader";
  }
}
#endif
