#ifndef __DAQBuilderStopWatch_HH__
#define __DAQBuilderStopWatch_HH__
#include <DAQBuilderObject.hh>
#include <System/DAQBuilderSystem.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  class StopWatch : public Object 
  {
  protected:
    enum{Running,Shutdown,NumStatus};
    DInt                     _status;
  protected:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const=0 ;
  public:
    DBool             equals( const StopWatch& right );
    DBool             equals( const Object * right );
  public:
    virtual void              start()=0;
    virtual void              stop()=0;
    virtual void              clear()=0;
  
    virtual DDouble           getOwnRealTime() const =0;
    virtual DDouble           getOwnSystemTime() const =0;
    virtual DDouble           getOwnUserTime() const =0;
    virtual DDouble           getOwnCPUTime() const =0;
  public :
    StopWatch();
    StopWatch( const StopWatch& right );
    virtual ~StopWatch();
  public:    
    virtual StopWatch& operator   =(const StopWatch & right );
    virtual DBool   operator   ==(const StopWatch& right ) const ;
    virtual DBool   operator   !=(const StopWatch& right ) const ;
  };
  inline void   StopWatch::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   StopWatch::_setType()
  {
    this -> _type = "StopWatch";
  }
}
#endif
