#include <System/DAQBuilderStopWatchImplementedByGetRUsage.hh>
namespace DAQBuilder
{
  DBool             StopWatchImplementedByGetRUsage::equals( const StopWatchImplementedByGetRUsage& right )
  {
    DBool aBool      = ((StopWatch*)this)->equals(*((StopWatch*)&right));
    aBool      |= right._beginTime.ru_utime.tv_usec 
                    ==     _beginTime.ru_utime.tv_usec;
    aBool      |= right._endTime.ru_utime.tv_sec 
                    ==     _endTime.ru_utime.tv_sec;
    aBool      |= right._beginTime.ru_stime.tv_usec 
                    ==     _beginTime.ru_stime.tv_usec;
    aBool      |= right._endTime.ru_stime.tv_sec 
                    ==     _endTime.ru_stime.tv_sec;
    aBool      |= right._beginClock.tv_usec 
                    ==     _beginClock.tv_usec;
    aBool      |= right._endClock.tv_sec 
                    ==     _endClock.tv_sec;
    return aBool;
  }
  DBool             StopWatchImplementedByGetRUsage::equals( const Object * right )
  {
    if(!findParent(_type,right))
         return false;
    return equals(*((StopWatchImplementedByGetRUsage*)right));
  }
  DBool   StopWatchImplementedByGetRUsage::operator   ==(const StopWatchImplementedByGetRUsage& right ) const 
  {
    DBool aBool = *((StopWatch*)this) ==  *((StopWatch*)&right);
    aBool      |= right._beginTime.ru_utime.tv_usec 
                    ==     _beginTime.ru_utime.tv_usec;
    aBool      |= right._endTime.ru_utime.tv_sec 
                    ==     _endTime.ru_utime.tv_sec;
    aBool      |= right._beginTime.ru_stime.tv_usec 
                    ==     _beginTime.ru_stime.tv_usec;
    aBool      |= right._endTime.ru_stime.tv_sec 
                    ==     _endTime.ru_stime.tv_sec;
    aBool      |= right._beginClock.tv_usec 
                    ==     _beginClock.tv_usec;
    aBool      |= right._endClock.tv_sec 
                    ==     _endClock.tv_sec;
    return aBool;
  }
  DBool   StopWatchImplementedByGetRUsage::operator   !=(const StopWatchImplementedByGetRUsage& right ) const 
  {
    DBool aBool = *((StopWatch*)this) !=  *((StopWatch*)&right);
    aBool      |= right._beginTime.ru_utime.tv_usec 
                    !=     _beginTime.ru_utime.tv_usec;
    aBool      |= right._endTime.ru_utime.tv_sec 
                    !=     _endTime.ru_utime.tv_sec;
    aBool      |= right._beginTime.ru_stime.tv_usec 
                    !=     _beginTime.ru_stime.tv_usec;
    aBool      |= right._endTime.ru_stime.tv_sec 
                    !=     _endTime.ru_stime.tv_sec;
    aBool      |= right._beginClock.tv_usec 
                    !=     _beginClock.tv_usec;
    aBool      |= right._endClock.tv_sec 
                    !=     _endClock.tv_sec;
    return aBool;
  }
  const DString StopWatchImplementedByGetRUsage::toString() const
  {
    DString aString="Now running !!";
    if(_status==StopWatch::Shutdown){
      aString  = "  Real          : ";
      aString += String::digitToString(getOwnRealTime());
      aString += "sec\n";
      aString += "  System        : ";
      aString += String::digitToString(getOwnSystemTime());
      aString += "sec\n";
      aString += "+)User          : ";
      aString += String::digitToString(getOwnUserTime());
      aString += "sec\n";
      aString += "-------------------------------------";
      aString += "\n";
      aString += "  CPUTime       : ";
      aString += String::digitToString(getOwnCPUTime());
      aString += "sec";
    }
    return aString;
  }
  StopWatchImplementedByGetRUsage::StopWatchImplementedByGetRUsage()
    :StopWatch()
  {
    _finalize();
    _setType();
    _setParentClasses();
  }
  StopWatchImplementedByGetRUsage::StopWatchImplementedByGetRUsage( const StopWatchImplementedByGetRUsage& right )
    :StopWatch(*((StopWatch*)&right))
  {
    bcopy(&right._beginTime,&_beginTime,sizeof(right._beginTime));
    bcopy(&right._endTime  ,&_endTime  ,sizeof(right._endTime  ));
    bcopy(&right._beginClock,&_beginClock,sizeof(right._beginClock));
    bcopy(&right._endClock  ,&_endClock  ,sizeof(right._endClock  ));
  }
  StopWatchImplementedByGetRUsage::~StopWatchImplementedByGetRUsage()
  {
    _finalize();
  }
  void              StopWatchImplementedByGetRUsage::clear()
  {
    _finalize();
   }
  StopWatchImplementedByGetRUsage& StopWatchImplementedByGetRUsage::operator   =(const StopWatchImplementedByGetRUsage & right )
  {
    *((Object*)this)=    *((Object*)&right);
    _status         =     right._status;
    bcopy(&right._beginTime,&_beginTime,sizeof(right._beginTime));
    bcopy(&right._endTime  ,&_endTime  ,sizeof(right._endTime  ));
    bcopy(&right._beginClock,&_beginClock,sizeof(right._beginClock));
    bcopy(&right._endClock  ,&_endClock  ,sizeof(right._endClock  ));
    return *this;
  }
}
