#ifndef __DAQBuilderStopWatchImplementedByGetRUsage_HH__
#define __DAQBuilderStopWatchImplementedByGetRUsage_HH__
#include <System/DAQBuilderStopWatch.hh>

namespace DAQBuilder
{
  class StopWatchImplementedByGetRUsage : public StopWatch
  {
   protected:
    struct rusage            _beginTime;
    struct rusage            _endTime;
    struct timeval           _beginClock;
    struct timeval           _endClock;
  protected:
    void                     _finalize();
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    DBool             equals( const StopWatchImplementedByGetRUsage& right );
    DBool             equals( const Object * right );
  public:
    const struct rusage&        getBeginTime() const ;
    const struct rusage&        getEndTime() const ;
  public:
    void              start();
    void              stop();
    void              clear();
    virtual DDouble           getOwnRealTime() const ;
    virtual DDouble           getOwnSystemTime() const ;
    virtual DDouble           getOwnUserTime() const ;
    virtual DDouble           getOwnCPUTime() const ;
  public :
    StopWatchImplementedByGetRUsage();
    StopWatchImplementedByGetRUsage( const StopWatchImplementedByGetRUsage& right );
    ~StopWatchImplementedByGetRUsage();
  public:    
    StopWatchImplementedByGetRUsage& operator   =(const StopWatchImplementedByGetRUsage & right );
    virtual DBool   operator   ==(const StopWatchImplementedByGetRUsage& right ) const ;
    virtual DBool   operator   !=(const StopWatchImplementedByGetRUsage& right ) const ;
  };
  inline void   StopWatchImplementedByGetRUsage::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("StopWatch");
  }
  inline void   StopWatchImplementedByGetRUsage::_setType()
  {
    this -> _type = "StopWatchImplementedByGetRUsage";
  }
  inline void StopWatchImplementedByGetRUsage::start()
  {
    if(_status == StopWatch::Shutdown ){
      getrusage(RUSAGE_SELF,&_beginTime);
      gettimeofday(&_beginClock,NULL);
      _status = Running;
    }
  }
  inline void StopWatchImplementedByGetRUsage::stop()
  {
    if(_status == StopWatch::Running ){
      getrusage(RUSAGE_SELF,&_endTime);
      gettimeofday(&_endClock,NULL);
      _status = Shutdown;
    }
  }
  inline DDouble           StopWatchImplementedByGetRUsage::getOwnRealTime() const
  {
     DDouble aBeginRealTime = (DDouble)_beginClock.tv_sec+(DDouble)_beginClock.tv_usec*1e-6;
     DDouble aEndRealTime   = (DDouble)_endClock.tv_sec+(DDouble)_endClock.tv_usec*1e-6;
   return aEndRealTime-aBeginRealTime;
  }
  inline DDouble           StopWatchImplementedByGetRUsage::getOwnSystemTime() const 
  {
     DDouble aBeginSystemTime = (DDouble)_beginTime.ru_stime.tv_sec+(DDouble)_beginTime.ru_stime.tv_usec*1e-6;
     DDouble aEndSystemTime   = (DDouble)_endTime.ru_stime.tv_sec+(DDouble)_endTime.ru_stime.tv_usec*1e-6;
     return aEndSystemTime-aBeginSystemTime;
   }
  inline DDouble           StopWatchImplementedByGetRUsage::getOwnUserTime() const 
  {
     DDouble aBeginUserTime = (DDouble)_beginTime.ru_utime.tv_sec+(DDouble)_beginTime.ru_utime.tv_usec*1e-6;
     DDouble aEndUserTime   = (DDouble)_endTime.ru_utime.tv_sec+(DDouble)_endTime.ru_utime.tv_usec*1e-6;
     return aEndUserTime-aBeginUserTime;
   }
  inline DDouble           StopWatchImplementedByGetRUsage::getOwnCPUTime() const 
  {
    return getOwnSystemTime()+getOwnUserTime();
  }
  inline  const struct rusage&        StopWatchImplementedByGetRUsage::getBeginTime() const
  {
    return _beginTime;
  } 
  inline  const struct rusage&        StopWatchImplementedByGetRUsage::getEndTime() const 
  {
    return _endTime;
  }
  inline void                     StopWatchImplementedByGetRUsage::_finalize()
  {
    bzero(&_beginTime,sizeof(_beginTime));
    bzero(&_endTime  ,sizeof(_endTime  ));
    bzero(&_beginClock,sizeof(_beginClock));
    bzero(&_endClock  ,sizeof(_endClock  ));
  }
}
#endif
