#include <System/DAQBuilderStopWatchImplementedByTimes.hh>
namespace DAQBuilder
{
  const DString StopWatchImplementedByTimes::toString() const
  {
    DString aString="Now running !!";
    if(_status==StopWatch::Shutdown){
      aString  = "  Real          : ";
      aString += String::digitToString(getOwnRealTime());
      aString += "sec\n";
      aString += "  System        : ";
      aString += String::digitToString(getOwnSystemTime());
      aString += "sec\n";
      aString += "+)User          : ";
      aString += String::digitToString(getOwnUserTime());
      
      aString += "sec\n";
      aString += "-------------------------------------";
      aString += "\n";
      aString += "  CPUTime       : ";
      aString += String::digitToString(getOwnCPUTime());
      aString += "sec\n";
      aString += "For Children      \n";
      aString += "  System        : ";
      aString += String::digitToString((DDouble)(((DDouble)_endTime.tms_cstime-(DDouble)_beginTime.tms_cstime)/(DDouble)_clocksPerSecond));
      aString += "sec\n";
      aString += "+)User          : ";
      aString += String::digitToString((DDouble)(((DDouble)_endTime.tms_cutime-(DDouble)_beginTime.tms_cutime)/(DDouble)_clocksPerSecond));
      aString += "sec\n";
      aString += "-------------------------------------";
      aString += "\n";
      aString += "  CPUTime       : ";
      aString += String::digitToString((DDouble)((((DDouble)_endTime.tms_cstime-(DDouble)_beginTime.tms_cstime)/(DDouble)_clocksPerSecond)+((DDouble)_endTime.tms_cutime-(DDouble)_beginTime.tms_cutime)/(DDouble)_clocksPerSecond));
      aString += "sec\n";
    }
    return aString;
  }
  const DDouble StopWatchImplementedByTimes::_clocksPerSecond= sysconf(_SC_CLK_TCK);
  DBool             StopWatchImplementedByTimes::equals( const StopWatchImplementedByTimes& right )
  {
    DBool aBool = _beginClock     ==     right._beginClock;
    aBool      |= _endClock       ==     right._endClock;
    aBool      |= ((StopWatch*)this)->equals(*((StopWatch*)&right));
    aBool      |= right._beginTime.tms_utime ==     _beginTime.tms_utime;
    aBool      |= right._beginTime.tms_stime ==     _beginTime.tms_stime;
    aBool      |= right._beginTime.tms_cutime ==     _beginTime.tms_cutime;
    aBool      |= right._beginTime.tms_cstime ==     _beginTime.tms_cstime;
    aBool      |= right._endTime.tms_utime ==     _endTime.tms_utime;
    aBool      |= right._endTime.tms_stime ==     _endTime.tms_stime;
    aBool      |= right._endTime.tms_cutime ==     _endTime.tms_cutime;
    aBool      |= right._endTime.tms_cstime ==     _endTime.tms_cstime;
    return aBool;
  }
  DBool             StopWatchImplementedByTimes::equals( const Object * right )
  {
    if(!findParent(_type,right))
         return false;
    return equals(*((StopWatchImplementedByTimes*)right));
  }
  DBool   StopWatchImplementedByTimes::operator   ==(const StopWatchImplementedByTimes& right ) const 
  {
    DBool aBool = *((StopWatch*)this) ==  *((StopWatch*)&right);
    aBool      |= _beginClock     ==     right._beginClock;
    aBool      |= _endClock       ==     right._endClock;
    aBool      |= right._beginTime.tms_utime ==     _beginTime.tms_utime;
    aBool      |= right._beginTime.tms_stime ==     _beginTime.tms_stime;
    aBool      |= right._beginTime.tms_cutime ==     _beginTime.tms_cutime;
    aBool      |= right._beginTime.tms_cstime ==     _beginTime.tms_cstime;
    aBool      |= right._endTime.tms_utime ==     _endTime.tms_utime;
    aBool      |= right._endTime.tms_stime ==     _endTime.tms_stime;
    aBool      |= right._endTime.tms_cutime ==     _endTime.tms_cutime;
    aBool      |= right._endTime.tms_cstime ==     _endTime.tms_cstime;
    return aBool;
  }
  DBool   StopWatchImplementedByTimes::operator   !=(const StopWatchImplementedByTimes& right ) const 
  {
    DBool aBool = *((StopWatch*)this) !=  *((StopWatch*)&right);
    aBool      |= _beginClock     !=     right._beginClock;
    aBool      |= _endClock       !=     right._endClock;
    aBool      |= right._beginTime.tms_utime !=     _beginTime.tms_utime;
    aBool      |= right._beginTime.tms_stime !=     _beginTime.tms_stime;
    aBool      |= right._beginTime.tms_cutime !=     _beginTime.tms_cutime;
    aBool      |= right._beginTime.tms_cstime !=     _beginTime.tms_cstime;
    aBool      |= right._endTime.tms_utime !=     _endTime.tms_utime;
    aBool      |= right._endTime.tms_stime !=     _endTime.tms_stime;
    aBool      |= right._endTime.tms_cutime !=     _endTime.tms_cutime;
    aBool      |= right._endTime.tms_cstime !=     _endTime.tms_cstime;
    return aBool;
  }
  StopWatchImplementedByTimes::StopWatchImplementedByTimes()
    :StopWatch()
  {
    _finalize();
    _setType();
    _setParentClasses();
  }
  StopWatchImplementedByTimes::StopWatchImplementedByTimes( const StopWatchImplementedByTimes& right )
    :StopWatch(*((StopWatch*)&right)),_beginClock(right._beginClock),_endClock(right._endClock)
  {
    bcopy(&right._beginTime,&_beginTime,sizeof(right._beginTime));
    bcopy(&right._endTime  ,&_endTime  ,sizeof(right._endTime  ));
  }
  StopWatchImplementedByTimes::~StopWatchImplementedByTimes()
  {
    _finalize();
  }
  void              StopWatchImplementedByTimes::clear()
  {
    _finalize();
  }
  StopWatchImplementedByTimes& StopWatchImplementedByTimes::operator   =(const StopWatchImplementedByTimes & right )
  {
    *((Object*)this)=    *((Object*)&right);
    _beginClock     =     right._beginClock;
    _endClock       =     right._endClock;
    _status         =     right._status;
    bcopy(&right._beginTime,&_beginTime,sizeof(right._beginTime));
    bcopy(&right._endTime  ,&_endTime  ,sizeof(right._endTime  ));
    return *this;
  }
}
