#ifndef __DAQBuilderStopWatchImplementedByTimes_HH__
#define __DAQBuilderStopWatchImplementedByTimes_HH__
#include <System/DAQBuilderStopWatch.hh>

namespace DAQBuilder
{
  class StopWatchImplementedByTimes : public StopWatch
  {
   protected:
    clock_t                  _beginClock;
    struct tms               _beginTime;
    clock_t                  _endClock;
    struct tms               _endTime;
   public:
    static const DDouble     _clocksPerSecond;
  protected:
    void                     _finalize();
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    DBool             equals( const StopWatchImplementedByTimes& right );
    DBool             equals( const Object * right );
  public:
    const clock_t&             getBeginClock() const ;
    const struct tms&        getBeginTime() const ;
    const clock_t&             getEndClock() const ;
    const struct tms&        getEndTime() const ;
    virtual DDouble           getOwnRealTime() const ;
    virtual DDouble           getOwnSystemTime() const ;
    virtual DDouble           getOwnUserTime() const ;
    virtual DDouble           getOwnCPUTime() const ;
  public:
    void              start();
    void              stop();
    void              clear();
  public :
    StopWatchImplementedByTimes();
    StopWatchImplementedByTimes( const StopWatchImplementedByTimes& right );
    ~StopWatchImplementedByTimes();
  public:    
    StopWatchImplementedByTimes& operator   =(const StopWatchImplementedByTimes & right );
    virtual DBool   operator   ==(const StopWatchImplementedByTimes& right ) const ;
    virtual DBool   operator   !=(const StopWatchImplementedByTimes& right ) const ;
  };
  inline void   StopWatchImplementedByTimes::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("StopWatch");
  }
  inline void   StopWatchImplementedByTimes::_setType()
  {
    this -> _type = "StopWatchImplementedByTimes";
  }
  inline void StopWatchImplementedByTimes::start()
  {
    if(_status == StopWatch::Shutdown ){
      _beginClock = times(&_beginTime);
      _status = Running;
    }
  }
  inline void StopWatchImplementedByTimes::stop()
  {
    if(_status == StopWatch::Running ){
      _endClock = times(&_endTime);
      _status = Shutdown;
    }
  }
  inline DDouble           StopWatchImplementedByTimes::getOwnRealTime() const 
  {
    return (DDouble)((DDouble)(_endClock-_beginClock)/(DDouble)_clocksPerSecond);
  }
  inline DDouble           StopWatchImplementedByTimes::getOwnSystemTime() const 
  {
    return (DDouble)(((DDouble)_endTime.tms_stime-(DDouble)_beginTime.tms_stime)/(DDouble)_clocksPerSecond);
  }
  inline DDouble           StopWatchImplementedByTimes::getOwnUserTime() const 
  {
    return (DDouble)(((DDouble)_endTime.tms_utime-(DDouble)_beginTime.tms_utime)/(DDouble)_clocksPerSecond);
  }
  inline DDouble           StopWatchImplementedByTimes::getOwnCPUTime() const 
  {
    return (DDouble)((((DDouble)_endTime.tms_stime-(DDouble)_beginTime.tms_stime)/(DDouble)_clocksPerSecond)+((DDouble)_endTime.tms_utime-(DDouble)_beginTime.tms_utime)/(DDouble)_clocksPerSecond);
  }
  inline  const clock_t&             StopWatchImplementedByTimes::getBeginClock() const 
  {
    return _beginClock;
  }
  inline  const struct tms&        StopWatchImplementedByTimes::getBeginTime() const
  {
    return _beginTime;
  } 
  inline  const clock_t&             StopWatchImplementedByTimes::getEndClock() const
  {
    return _endClock;
  } 
  inline  const struct tms&        StopWatchImplementedByTimes::getEndTime() const 
  {
    return _endTime;
  }
  inline void                     StopWatchImplementedByTimes::_finalize()
  {
    bzero(&_beginTime,sizeof(_beginTime));
    bzero(&_endTime  ,sizeof(_endTime  ));
    _beginClock = 0 ;
    _endClock   = 0 ;
  }
}
#endif
