#include <System/DAQBuilderSystem.hh>
#include <System/DAQBuilderTimestamp.hh>
#include <System/IO/DAQBuilderStandardOutput.hh>
#include <System/IO/DAQBuilderStandardError.hh>
#include <System/IO/DAQBuilderStandardInput.hh>
#include <System/IO/DAQBuilderCommandOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>
extern char ** environ;
namespace DAQBuilder
{
  Properties               System:: _properties; 
  PrintStream              System:: out     = StandardOutput();
  PrintStream              System:: err     = StandardError();
  ScanStream               System:: in      = StandardInput();
  CommandOutputStream      System:: command;
  const  DString           System::toString() const 
  {
    System::_update();
    DString aString ;//= _toStringHeader();
    for( Properties::const_iterator iter = System::_properties.begin();
	 iter != System::_properties.end(); 
	 iter++)
      {
	aString += iter -> first;
	aString += "=";
        aString += iter -> second;
	aString += "\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
  DULong             System::currentTimeMillis()  
  {
    struct timeval currentTime;
    ::gettimeofday(&currentTime,NULL);
    return (DULong)(((DULong)(currentTime.tv_sec)*1000)+(((DULong)currentTime.tv_usec)/1000));
  } 
  void              System::exit( DInt status ) 
  {
    ::exit((int)status);
  } 
  const Properties& System::getProperties() 
  {
    System::_update();
    return System::_properties;
  }
  DString    System::getProperty( const DString & key ) 
  {
    System::_update();
    Properties::const_iterator iter = System::_properties.find(key);
    if( System::_properties.empty() 
	|| iter == System::_properties.end())
        return DString();

    return iter -> second;
  }
  void              System::setProperties( Properties &  _properties )
  {
    System::_properties = _properties;
  }
  void              System::clearProperty()
  {
   ::clearenv(); 
    System::_properties.clear();
  }
  void              System::deleteProperty( const DString& key )
  {
    if(::getenv(key.c_str())!=NULL)
      ::unsetenv(key.c_str());

    Properties::iterator iter = System::_properties.find(key);
    if( !(System::_properties.empty()) 
	&& !(iter == System::_properties.end()))
      System::_properties.erase(iter);
  }
  void              System::setProperty( const DString& key , const DString&  value )
  {
    if(::getenv(key.c_str())!=NULL)
      ::setenv(key.c_str(),value.c_str(),1);

    Properties::iterator iter = System::_properties.find(key);
    if( !(System::_properties.empty()) 
	&& !(iter == System::_properties.end()))
      System::_properties.erase(iter);
    System::_properties.insert( std::pair<DString,DString>( key , value ));	  
   }
  void System::_update()
  {
    System::setProperty("CurrentTimeMillis",String::digitToString(System::currentTimeMillis()));
    System::setProperty("Time             ",Timestamp(System::currentTimeMillis()).toString());
    System::_setupEnvironmentValue();
  }
  void       System::_setupEnvironmentValue()
  {
    char ** _environment = environ;
    if(_environment==NULL)
      return;
    for( _environment = environ ; *_environment != NULL; _environment++)
    {
      DString aString     = *_environment;
      DString environment = aString.substr( 0,aString.find_first_of("=",0));
      DString value       = aString.substr( aString.find_first_of("=",0)+1,aString.length());
      if(environment=="_")
       environment="COMMAND_NAME";
      System::setProperty(environment,value);
    }
  }
  System::System()
  {
    System::_update();
    _setType();
    _setParentClasses();
  }  
  System::System( const System& right )
  {
    System::_update();
    _setType();
    _setParentClasses();
  }  
  System::~System()
  {
    _finalize();
  }
  
  System& System::operator=(const System & right )
  {
    System::_update();
    return *this;
  }
  DBool   System::operator   ==(const System & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   System::operator   !=(const System & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
}
