#ifndef __DAQBuilderSystem_HH__
#define __DAQBuilderSystem_HH__
#include <System/IO/DAQBuilderCommandOutputStream.hh>
#include <System/IO/DAQBuilderPrintStream.hh>
#include <System/IO/DAQBuilderScanStream.hh>

namespace DAQBuilder
{
  class System : public Object 
  {
  private:
    static Properties        _properties; 
  private:
    void              _setType();
    void              _setParentClasses();
  private:
   static void              _update();
   static void       _setupEnvironmentValue();
  public:
   static  PrintStream              out;
   static  PrintStream              err;
   static  ScanStream               in; 
   static  CommandOutputStream      command;
  public:
    const  DString           toString() const ;
  public:
    static DULong            currentTimeMillis() ; 
    static void              exit( DInt status ) ;
    static const Properties& getProperties();
    static DString           getProperty( const DString & key ) ;
    static void              setProperties( Properties &  _properties );
    static void              setProperty( const DString& key , const DString&  value );
    static void              deleteProperty( const DString& key );
    static void              clearProperty();
    static void              setErr( PrintStream& err );
    static void              setOut( PrintStream& out );
  public :
    System();
    System( const System& right );
    ~System();
  public:    
    System& operator   =(const System & right );
    virtual DBool   operator   ==(const System& right ) const ;
    virtual DBool   operator   !=(const System& right ) const ;
  };
  inline void   System::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   System::_setType()
  {
    this -> _type = "System";
  }
  inline   void              System::setErr( PrintStream& perr )
  {
    System::err = err;
  }
  inline   void              System::setOut( PrintStream& pout )
  {
    System::out = pout;
  }
}
#endif
