#include <System/DAQBuilderSystemVIPC.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void SystemVIPC::_finalize()
  {;}
  
  const DString SystemVIPC::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString += "SystemVPath : ";
    aString += _systemVPath;
    aString += "\n";
    aString += "SystemVID   : ";
    aString += String::digitToString((DLong)_systemVID);
    aString += "\n";
    aString += "IPCKey      : ";
    aString += String::digitToString((DLong)_ipcKey);
    aString += "\n";
    aString += "IPCID       : ";
    aString += String::digitToString((DLong)_ipcID);
    aString += "\n";
    //aString += _toStringFooter();
    return aString;
  }
  
  SystemVIPC::SystemVIPC( const DString& systemVPath , const  DInt & systemVID )
    :Object(),_ipcKey(-1),_ipcID(-1)
  {
   _setType();
   _setParentClasses();
    if( systemVID < 0 )
      _ipcKey = IPC_PRIVATE;
    else if( systemVPath.empty() )
      {
	char tmp[256];
	::getcwd(tmp,sizeof(tmp)-1);
	_systemVPath = DString(tmp);
	_systemVID   = systemVID;
      }
    else
      {
	_systemVPath = systemVPath;
	_systemVID   = systemVID;
      }
  }
   DInt                           SystemVIPC::getIPCID()
      throw(Exception * )
  {
    if( _ipcID < 0 )
      throw new Exception(" DInt          SystemVIPC::getIpcID() Don't Create ID ");
    
    return _ipcID;
  }
  key_t                         SystemVIPC::getIPCKey()
      throw(Exception * )
  {
    if( _ipcKey < 0 )
      {
	if( (_ipcKey = ::ftok( _systemVPath.c_str() , _systemVID )) < 0 )
	  throw new Exception("key_t   SystemVIPC::getIpcKey() key_t ftok( cosnt char* , DInt )");
      }
    return _ipcKey;
  }
  const DString &           SystemVIPC::getSystemVPath() const 
  {
    return _systemVPath;
  }
  const  DInt &                    SystemVIPC::getSystemVID() const 
    {
      return _systemVID;
    }
  SystemVIPC& SystemVIPC::operator =(const SystemVIPC& right )
  {
    *((Object*)this) =       *((Object*)&right);
    _systemVPath  = right._systemVPath;
    _systemVID    = right._systemVID;
    _ipcKey       = right._ipcKey;
    _ipcID        = right._ipcID;
   return *this; 
  }
  DBool   SystemVIPC::operator   ==(const SystemVIPC & right ) const 
  {
    DBool aBool = *((Object*)this)==  *((Object*)&right);
    aBool      |=  _systemVPath   == right._systemVPath;
    aBool      |=    _systemVID   == right._systemVID;
    aBool      |=    _ipcKey      == right._ipcKey;
    aBool      |=   _ipcID        == right._ipcID;
    return aBool;
  }
  DBool   SystemVIPC::operator   !=(const SystemVIPC & right ) const 
  {
    DBool aBool = *((Object*)this)!=  *((Object*)&right);
    aBool      |=  _systemVPath   != right._systemVPath;
    aBool      |=    _systemVID   != right._systemVID;
    aBool      |=    _ipcKey      != right._ipcKey;
    aBool      |=   _ipcID        != right._ipcID;
    return aBool;
  }
}

