#ifndef _DAQBuilderSystemVIPC_HH__
#define _DAQBuilderSystemVIPC_HH__
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class SystemVIPC : public Object 
  {
  protected:
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    DString                    _systemVPath;
    DInt                       _systemVID;
    key_t                      _ipcKey;
    DInt                       _ipcID;
  public:
    virtual  const DString     toString() const ;
    DInt                          getIPCID()
      throw(Exception * );
    key_t                         getIPCKey()
      throw(Exception * );
    const DString &               getSystemVPath() const ;
    const int&                    getSystemVID() const ;
  public:
    SystemVIPC( const DString& _systemVPath="" , const DInt& _systemVID = 0 );
    virtual ~SystemVIPC();
    SystemVIPC& operator            =(const SystemVIPC & right );
    virtual DBool   operator   ==(const SystemVIPC& right ) const ;
    virtual DBool   operator   !=(const SystemVIPC& right ) const ;
  };
  inline   SystemVIPC::~SystemVIPC()
  {
    this -> _finalize();
  }

  inline void SystemVIPC::_setType()
  {
    this -> _type = "SystemVIPC";
  }
  inline void SystemVIPC::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
}
#endif
