#include <System/DAQBuilderSystemVMessageQueue.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void SystemVMessageQueue::_finalize()
  {
    ::msgctl(_ipcID,IPC_RMID,NULL);
  }
  
  const DString SystemVMessageQueue::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString += "SystemVPath          : ";
    aString += _systemVPath;
    aString += "\n";
    aString += "SystemVID            : ";
    aString += String::digitToString((DLong)_systemVID);
    aString += "\n";
    aString += "MessageQueueKey      : ";
    aString += String::digitToString((DLong)_ipcKey);
    aString += "\n";
    aString += "MessageQueueID       : ";
    aString += String::digitToString((DLong)_ipcID);
    aString += "\n";
    aString += "Owner UserID         : ";
    aString += String::digitToString((DLong)_messageQueueIDDS.msg_perm.uid);
    aString += "\n";
    aString += "Owner GroupID        : ";
    aString += String::digitToString((DLong)_messageQueueIDDS.msg_perm.gid);
    aString += "\n";
    aString += "Creater UserID       : ";
    aString += String::digitToString((DLong)_messageQueueIDDS.msg_perm.cuid);
    aString += "\n";
    aString += "Creater GroupID      : ";
    aString += String::digitToString((DLong)_messageQueueIDDS.msg_perm.cgid);
    aString += "\n";
    //aString += _toStringFooter();
    return aString;
  }
  void               SystemVMessageQueue::_iddsUpdate()
  {
    ::msgctl( _ipcID , IPC_STAT , & _messageQueueIDDS );
  }
  SystemVMessageQueue::SystemVMessageQueue( const DString& systemVPath , const DInt& systemVID )
    :SystemVIPC(systemVPath,systemVID)
  {
   _setType();
   _setParentClasses();
   ::bzero(&_messageQueueIDDS,sizeof(struct msqid_ds));
   _ipcID = ::msgget( getIPCKey() , 
		      IPC_CREAT | 0666 
		   );
   //std::cout<< this << std::endl;
   _iddsUpdate();
  }
  SystemVMessageQueue::SystemVMessageQueue( SystemVMessageQueue & _right)
    :SystemVIPC(_right._systemVPath,_right._systemVID)
  {
   _setType();
   _setParentClasses();
   ::bzero(&_messageQueueIDDS,sizeof(struct msqid_ds));
   _ipcID = ::msgget( getIPCKey() , 
		      IPC_CREAT | 0666 
		   );
   //std::cout<< this << std::endl;
   _iddsUpdate();
  }

  DInt SystemVMessageQueue::send(const SystemVMessageQueuePacket *MessageQueuePacket, DInt MessageLength) 
    throw(Exception *)
  {
    DInt MessageFlag = 0;
    /*DIntResult = */msgsnd(
        _ipcID, (void*) MessageQueuePacket, MessageLength, MessageFlag
    );

    DInt SentLength = MessageLength;
    /*if (Result < 0) {
	if ((errno == EINTR) || (errno == EAGAIN)) {
	    SentLength = 0;
	}
	else {
	  throw new Exception("DIntSystemVMessageQueue::send(const SystemVMessageQueuePacket *, int) msgsnd()"
	    );
	}
    }
    */

    return SentLength;
  }
  DInt SystemVMessageQueue::receive(SystemVMessageQueuePacket *MessageQueuePacket, DInt MaxMessageLength, DBool NoWait ) 
    throw(Exception *)
  {
    DInt MessageFlag = (NoWait) ? IPC_NOWAIT : 0;

    DInt Result = msgrcv(
        _ipcID, 
        (void*) MessageQueuePacket, MaxMessageLength, 0, MessageFlag
    );

    DInt ReceivedLength = Result;
    /*if (Result < 0) {
	if ((errno == EINTR) || (errno == EAGAIN) || (errno == ENOMSG)) {
	    ReceivedLength = 0;
	}
	else {
	    throw new Exception("DIntSystemVMessageQueue::receive(SystemVMessageQueuePacket *, DInt, DBoolNoWait = false) : msgrcv(2)"
	    );
	}
    }*/

    return ReceivedLength;
  }
  SystemVMessageQueue& SystemVMessageQueue::operator =(const SystemVMessageQueue& right )
  {
    *((SystemVIPC*)this) =       *((SystemVIPC*)&right);
    _messageQueueIDDS= right._messageQueueIDDS;
    return *this;
  }
  DBool   SystemVMessageQueue::operator   ==(const SystemVMessageQueue & right ) const 
  {
    DBool aBool = *((SystemVIPC*)this) ==  *((SystemVIPC*)&right);
    aBool      |=  memcmp((void*)&_messageQueueIDDS,(void*)&right._messageQueueIDDS,sizeof(_messageQueueIDDS));
    return aBool;
  }
  DBool   SystemVMessageQueue::operator   !=(const SystemVMessageQueue & right ) const 
  {
    DBool aBool = *((SystemVIPC*)this) !=  *((SystemVIPC*)&right);
    aBool      |=  !memcmp((void*)&_messageQueueIDDS,(void*)&right._messageQueueIDDS,sizeof(_messageQueueIDDS));
    return aBool;
  }
}
