#ifndef _DAQBuilderSystemVMessageQueue_HH__
#define _DAQBuilderSystemVMessageQueue_HH__
#include <System/DAQBuilderSystemVIPC.hh>
namespace DAQBuilder
{
  class SystemVMessageQueue : public SystemVIPC
  {
  protected:
    virtual               void _finalize();

    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    struct msqid_ds            _messageQueueIDDS;
  protected:
    virtual  void               _iddsUpdate();
  public:
    virtual  const DString toString() const ;
    virtual DInt send(const SystemVMessageQueuePacket *MessageQueuePacket, DInt MessageLength) 
      throw(Exception *);
    virtual DInt receive(SystemVMessageQueuePacket *MessageQueuePacket, DInt MaxMessageLength, DBool NoWait = false) 
      throw(Exception *);
  public:
    SystemVMessageQueue( const DString& _systemVPath="" , const DInt& _systemVID = 0 );
    SystemVMessageQueue( SystemVMessageQueue & _right);
    virtual ~SystemVMessageQueue();
    SystemVMessageQueue& operator            =(const SystemVMessageQueue & right );
    virtual DBool   operator   ==(const SystemVMessageQueue& right ) const ;
    virtual DBool   operator   !=(const SystemVMessageQueue& right ) const ;
  };
  inline   SystemVMessageQueue::~SystemVMessageQueue()
  {
    this -> _finalize();
  }
  inline void SystemVMessageQueue::_setType()
  {
    this -> _type = "SystemVMessageQueue";
  }
  inline void SystemVMessageQueue::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SystemVMessageQueue");
  }
}
#endif
