#include <System/DAQBuilderSystemVSemaphore.hh>
namespace DAQBuilder
{
  void              SystemVSemaphore::_finalize()
  {
    detach();
    if(_ipcID>=0)
      remove();
  }
  void              SystemVSemaphore::_iddsUpdate()
     throw(IOException *)
  {
    if(shmctl(_ipcID,IPC_STAT,&_sharedMemoryIDDS)!=0){
		IOException * e = new IOException(strerror(errno));
		e -> insert("Location","SystemVSemaphore::_iddsUpdate()");
		throw e;
    }
  }
  const DString SystemVSemaphore::toString() const 
  {
    DString aString = ((SystemVIPC*)this)->toString(); 
    return aString;
  }
  SystemVSemaphore::SystemVSemaphore( const size_t& sharedMemorySize  , const DString& systemVPath , const DInt& systemVID  )
     :SystemVIPC(systemVPath,systemVID),_sharedMemoryAddress(NULL),
      _sharedMemorySize(sharedMemorySize),_currentPosition(0)
  {
    _setType();
    _setParentClasses();
    _ipcID = shmget( getIPCKey() , _sharedMemorySize , IPC_CREAT | IPC_EXCL | 0600 );
    _iddsUpdate();
    if(_ipcID<0){
      IOException * e = new IOException("Cant get shared memory");
      e ->  insert("Location","SystemVSemaphore()");
      throw e;
    }
  }
  SystemVSemaphore::SystemVSemaphore( SystemVSemaphore & right)
    :SystemVIPC(*((SystemVIPC*)&right)),_sharedMemoryIDDS(right._sharedMemoryIDDS),_sharedMemoryAddress(right._sharedMemoryAddress),
     _sharedMemorySize(right._sharedMemorySize),_currentPosition(right._currentPosition)
  {
  }
  void SystemVSemaphore::attach()
    throw(IOException *)
  {
    _sharedMemoryAddress = shmat(_ipcID,NULL,0);
    if((int)_sharedMemoryAddress==-1){
      IOException * e = new IOException("Cant attach shared memory");
      e ->  insert("Location","SystemVSemaphore::attach()");
      throw e;
    }
    _iddsUpdate();
  }
  void SystemVSemaphore::detach()
    throw(IOException *){
    if(_sharedMemoryAddress!=NULL){
      int returnValue = shmdt((const void*)_sharedMemoryAddress);
      if(returnValue==-1){
	IOException * e = new IOException("Cant detach shared memory");
	e ->  insert("Location","SystemVSemaphore::detach()");
	throw e;
      }
    }
    _iddsUpdate();
  }
  void SystemVSemaphore::remove()
    throw(IOException *)
  {
    if(shmctl(_ipcID,IPC_RMID,&_sharedMemoryIDDS)!=0){
		IOException * e = new IOException(strerror(errno));
		e -> insert("Location","SystemVSemaphore::remove()");
		throw e;
    }
  }
  
}
