#ifndef _DAQBuilderSystemVSemaphore_HH__
#define _DAQBuilderSystemVSemaphore_HH__
#include <System/DAQBuilderSystemVIPC.hh>
#include <Exception/DAQBuilderIOException.hh>
namespace DAQBuilder
{
  class SystemVSemaphore : public SystemVIPC
  {
  protected:
    virtual  void              _finalize();

    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    struct shmid_ds            _sharedMemoryIDDS;
    volatile void *            _sharedMemoryAddress;
    volatile size_t            _sharedMemorySize;
    volatile size_t            _currentPosition;
  protected:
    void                       _iddsUpdate()
     throw(IOException *);
  public:
    virtual  const DString toString() const ;
  public:
    SystemVSemaphore( const size_t& _sharedMemorySize = 1024 , const DString& _systemVPath="" , const DInt& _systemVID = 0 );
    SystemVSemaphore( SystemVSemaphore & _right);
    virtual ~SystemVSemaphore();
  public:
    void attach()
     throw(IOException *);
    void detach()
     throw(IOException *);
    void remove()
     throw(IOException *);
  };
  inline   SystemVSemaphore::~SystemVSemaphore()
  {
    this -> _finalize();
  }
  inline void SystemVSemaphore::_setType()
  {
    this -> _type = "SystemVSemaphore";
  }
  inline void SystemVSemaphore::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SystemVIPC");
  }
}
#endif
