#include <System/DAQBuilderSystemVSharedMemory.hh>
namespace DAQBuilder
{
  void              SystemVSharedMemory::_finalize()
  {
    detach();
    if(_ipcID>=0)
      remove();
  }
  void              SystemVSharedMemory::_iddsUpdate()
     throw(IOException *)
  {
    if(shmctl(_ipcID,IPC_STAT,&_sharedMemoryIDDS)!=0){
		IOException * e = new IOException(strerror(errno));
		e -> insert("Location","SystemVSharedMemory::_iddsUpdate()");
		throw e;
    }
  }
  const DString SystemVSharedMemory::toString() const 
  {
    DString aString = ((SystemVIPC*)this)->toString(); 
    return aString;
  }
  SystemVSharedMemory::SystemVSharedMemory( const size_t& sharedMemorySize  , const DString& systemVPath , const DInt& systemVID  )
     :SystemVIPC(systemVPath,systemVID),_sharedMemoryAddress(NULL),
      _sharedMemorySize(sharedMemorySize),_currentPosition(0)
  {
    _setType();
    _setParentClasses();
    _ipcID = shmget( getIPCKey() , _sharedMemorySize , IPC_CREAT | IPC_EXCL | 0600 );
    _iddsUpdate();
    if(_ipcID<0){
      IOException * e = new IOException("Cant get shared memory");
      e ->  insert("Location","SystemVSharedMemory()");
      throw e;
    }
  }
  SystemVSharedMemory::SystemVSharedMemory( SystemVSharedMemory & right)
    :SystemVIPC(*((SystemVIPC*)&right)),_sharedMemoryIDDS(right._sharedMemoryIDDS),_sharedMemoryAddress(right._sharedMemoryAddress),
     _sharedMemorySize(right._sharedMemorySize),_currentPosition(right._currentPosition)
  {
  }
  void SystemVSharedMemory::attach()
    throw(IOException *)
  {
    _sharedMemoryAddress = shmat(_ipcID,NULL,0);
    if((int)_sharedMemoryAddress==-1){
      IOException * e = new IOException("Cant attach shared memory");
      e ->  insert("Location","SystemVSharedMemory::attach()");
      throw e;
    }
    _iddsUpdate();
  }
  void SystemVSharedMemory::detach()
    throw(IOException *){
    if(_sharedMemoryAddress!=NULL){
      int returnValue = shmdt((const void*)_sharedMemoryAddress);
      if(returnValue==-1){
	IOException * e = new IOException("Cant detach shared memory");
	e ->  insert("Location","SystemVSharedMemory::detach()");
	throw e;
      }
    }
    _iddsUpdate();
  }
  void SystemVSharedMemory::remove()
    throw(IOException *)
  {
    if(shmctl(_ipcID,IPC_RMID,&_sharedMemoryIDDS)!=0){
		IOException * e = new IOException(strerror(errno));
		e -> insert("Location","SystemVSharedMemory::remove()");
		throw e;
    }
  }
  
  SystemVSharedMemory& SystemVSharedMemory::operator =(const SystemVSharedMemory& right )
  {
    *((SystemVIPC*)this) =       *((SystemVIPC*)&right);
    _sharedMemoryIDDS    =right._sharedMemoryIDDS;
    _sharedMemoryAddress =right._sharedMemoryAddress;
    _sharedMemorySize    =right._sharedMemorySize;
    _currentPosition     =right._currentPosition;
    return *this;
  }
  DBool   SystemVSharedMemory::operator   ==(const SystemVSharedMemory & right ) const 
  {
    DBool aBool = *((SystemVIPC*)this) ==  *((SystemVIPC*)&right);
    aBool      |=  memcmp((void*)&_sharedMemoryIDDS,(void*)&right._sharedMemoryIDDS,sizeof(_sharedMemoryIDDS));
    aBool      |= _sharedMemoryAddress ==right._sharedMemoryAddress;
    aBool      |= _sharedMemorySize    ==right._sharedMemorySize;
    aBool      |= _currentPosition     ==right._currentPosition;
    return aBool;
  }
  DBool   SystemVSharedMemory::operator   !=(const SystemVSharedMemory & right ) const 
  {
    DBool aBool = *((SystemVIPC*)this) !=  *((SystemVIPC*)&right);
    aBool      |=  !memcmp((void*)&_sharedMemoryIDDS,(void*)&right._sharedMemoryIDDS,sizeof(_sharedMemoryIDDS));
    aBool      |= _sharedMemoryAddress !=right._sharedMemoryAddress;
    aBool      |= _sharedMemorySize    !=right._sharedMemorySize;
    aBool      |= _currentPosition     !=right._currentPosition;
    return aBool;
  }
}
