#ifndef _DAQBuilderSystemVSharedMemory_HH__
#define _DAQBuilderSystemVSharedMemory_HH__
#include <System/DAQBuilderSystemVIPC.hh>
#include <Exception/DAQBuilderIOException.hh>
namespace DAQBuilder
{
  class SystemVSharedMemory : public SystemVIPC
  {
  protected:
    virtual  void              _finalize();

    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    struct shmid_ds            _sharedMemoryIDDS;
    volatile void *            _sharedMemoryAddress;
    volatile size_t            _sharedMemorySize;
    volatile size_t            _currentPosition;
  protected:
    void                       _iddsUpdate()
     throw(IOException *);
  public:
    virtual  const DString toString() const ;
  public:
    SystemVSharedMemory( const size_t& _sharedMemorySize = 1024 , const DString& _systemVPath="" , const DInt& _systemVID = 0 );
    SystemVSharedMemory( SystemVSharedMemory & _right);
    virtual ~SystemVSharedMemory();
    SystemVSharedMemory& operator            =(const SystemVSharedMemory & right );
    virtual DBool   operator   ==(const SystemVSharedMemory& right ) const ;
    virtual DBool   operator   !=(const SystemVSharedMemory& right ) const ;
  public:
    void attach()
     throw(IOException *);
    void detach()
     throw(IOException *);
    void remove()
     throw(IOException *);
  };
  inline   SystemVSharedMemory::~SystemVSharedMemory()
  {
    this -> _finalize();
  }
  inline void SystemVSharedMemory::_setType()
  {
    this -> _type = "SystemVSharedMemory";
  }
  inline void SystemVSharedMemory::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SystemVIPC");
  }
}
#endif
