#include <System/DAQBuilderThread.hh>
#include <System/DAQBuilderThreadRegistry.hh>
#include <Util/DAQBuilderRandomEngine.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void*  Thread::_threadEntry(void * _target) 
  {
    ((Runnable *) _target)->run();
    return 0;
  }
  
  DLong Thread::getID() const 
  {
    //return (DLong)pthread_self();
    return _id;
  }
  
  DBool Thread::_makeID() 
  {
    RandomEngine r;
    _id = r.getRandom();
    try{
    ThreadRegistry::add(_id,this);
    }catch(Exception * e){
      return false;
    }
    return true;

  }
  
  Thread::Thread(Runnable* runnable )
    :Object(),_target(NULL), _isDeamon(false), _isActive(false),_isThis(false)
  { 
    copyAddress((Object*&)_target,(Object*&)runnable);
    pthread_attr_init(&_attribute);
    _setType();
    _setParentClasses();
    while(!_makeID());
  }
  Thread::Thread()
    :Object(),_target(this), _isDeamon(false), _isActive(false),_isThis(true)
  {
    pthread_attr_init(&_attribute);
    _setType();
    _setParentClasses();
    while(!_makeID());
  }
  
  Thread::Thread(const Thread& right ) 
    :Object(*(Object*)&right),/*_target(right._target),*/_isDeamon(right._isDeamon), _isActive(right._isActive),_isThis(right._isThis)
  {
    pthread_attr_init(&_attribute);
    if(right._isThis)
      _target = this;
    else
     copyAddress((Object*&)_target,(Object*&)right._target);
    while(!_makeID());
    /*_id = right._id;
    */
    //std::cout<<"Check"<<std::endl;
  }

 Thread& Thread::operator=(const Thread& right )
 {
    *((Object*)this) = *((Object*)&right);
  _isDeamon=right._isDeamon;
  _isActive=right._isActive;
  _isThis=right._isThis;
    if(right._isThis)
      _target = this;
    else
     copyAddress((Object*&)_target,(Object*&)right._target);
    _finalize();
    _id = right._id;
    pthread_attr_init(&_attribute);
    return *this;
 }
  void Thread::_finalize()
  {
    pthread_attr_destroy(&_attribute);
    ThreadRegistry::del(getID());
  }
  void Thread::start() 
    throw( ThreadException * )
  {
    if (pthread_create(&_threadObject, &_attribute,Thread::_threadEntry,this -> _target ) != 0) 
      throw new ThreadException("Thread::start() CannotCreateThread");
    activate();
  }
  
  DLong Thread::join() const 
    throw( ThreadException * )
  {
    
    DLong ** exitStatus=NULL;
    DLong    rExitStatus=0;
    if (pthread_join(_threadObject, (void**)exitStatus) != 0) 
      throw new ThreadException("Thread::join() CannotJoinThread");
    
    /*if(exitStatus != NULL)
       rExitStatus = *((DLong*)(*((DLong**)exitStatus)));
    */
     
    return rExitStatus;
  }
  
  void Thread::setDeamon() const 
    throw( ThreadException * )
  {
    if (pthread_detach(_threadObject)!= 0) 
      throw new ThreadException("Thread::detach() CannotDetachThread");
    _isDeamon = true;
  }

  const DBool& Thread::isDeamon() const 
  {
    return _isDeamon;
  }
  
  void Thread::cancel() const 
    throw( ThreadException * )
  {
    if (pthread_cancel(_threadObject)!= 0) 
      throw new ThreadException("Thread::cancel() CannotCancelThread");
  }
  void Thread::testCancel() const 
  {
    pthread_testcancel();
  }
  
  void Thread::run()
  {;}
  void Thread::yield() const 
  {
    sleep(1);
  }
  void Thread::activate()
    throw(ThreadException *)
  {
    _lock();
    _isActive=true;
    _unLock();
    notifyAll();
  }
  void  Thread::deactivate()
    throw(ThreadException *)
  {
    _lock();
    _isActive=false;
    _unLock();
    notifyAll();
  }
 DInt  Thread::exit()
   throw(ThreadException *)
      {
	DInt status = 0;
	pthread_exit(&status);
	return status;
      }
  const DString   Thread::toString() const
  {
    DString aString ;//= _toStringHeader();
    aString += "IsDeamon : ";
    _isDeamon ? 
      aString += "True"
      :      aString += "False";
    aString += "IsActive : ";
    _isActive ? 
      aString += "True"
      :      aString += "False";
    aString += "IsThis : ";
    _isThis ? 
      aString += "True"
      :      aString += "False";
    aString += "\n";
    aString += "ID       : ";
    aString += String::digitToString((DLong)getID());
    aString += "\n";
    //aString        += _toStringFooter();
    return aString;
  }
  DBool   Thread::operator   ==(const Thread & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    aBool      |= _id              == right._id;
    aBool      |= pthread_equal(_threadObject,right._threadObject);
    return aBool;
  }
  DBool   Thread::operator   !=(const Thread & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    aBool      |= _id              !=  right._id;
    aBool      |= !pthread_equal(_threadObject,right._threadObject);
    return aBool;
  }
}
