#ifndef _DAQBuilderThread_HH__
#define _DAQBuilderThread_HH__
#include <Exception/DAQBuilderThreadException.hh>
#include <Interface/DAQBuilderRunnable.hh>

namespace DAQBuilder
{
  class Thread : public Object , public  Runnable 
  {
  protected:
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    DLong                _id;
    pthread_t           _threadObject;
    pthread_attr_t      _attribute;
    Runnable*           _target;

    mutable DBool        _isDeamon;
    mutable DBool        _isActive;
    mutable DBool        _isThis;

    static void*        _threadEntry(void * _runnable) ;
    DBool              _makeID();
  public:
    virtual  const DString    toString() const ;
    virtual       ~Thread();
    virtual      void run();
    DLong          getID() const ;

    virtual void start() 
      throw(ThreadException *);

    DLong join() const 
      throw(ThreadException *);

    void setDeamon() const 
      throw(ThreadException *);

    const DBool& isDeamon() const ;

    void cancel()const
      throw(ThreadException *);

    void testCancel() const ;

    void yield() const ;

    DBool  tryLock() 
      throw(ThreadException *);
    void  activate()
      throw(ThreadException *);
    void  deactivate()
      throw(ThreadException *);
    DInt    exit()
      throw(ThreadException *);
  public:
    Thread();
    Thread(Runnable* _target );
    Thread(const Thread& right ) ;
    virtual Thread& operator   = (const Thread& right ) ;
    virtual DBool   operator   ==(const Thread& right ) const ;
    virtual DBool   operator   !=(const Thread& right ) const ;
  };
  inline   Thread::~Thread()
  {
    this -> _finalize();
  }

  inline void Thread::_setType()
  {
    this -> _type = "Thread";
  }
  inline void Thread::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
  }
}
#endif
