#include <System/DAQBuilderThreadRegistry.hh>
#include <System/DAQBuilderThread.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  ThreadRegistry *ThreadRegistry::_uniqueRegistry            = NULL;
  
  void  ThreadRegistry::_finalize()
  {
  }
  
  const DString ThreadRegistry::toString() const 
  {
    DString aString ;//= _toStringHeader();
    for( std::map< DLong , Thread *> :: iterator iter= (ThreadRegistry::_uniqueRegistry-> _table).begin() ; 
	 iter != (ThreadRegistry::_uniqueRegistry-> _table).end() ; 
	 iter++)
      {
	aString            += "( ";
	aString            += String::digitToString(iter -> first);
	aString            += " , ";
	aString            += (iter ->second)->getType();
	aString            += " )\n";
      }
    //aString += _toStringFooter();
    return aString;
  }
  
  void ThreadRegistry::add( const DLong& objID , Thread * obj )
      throw( SameNameBindedException * )
  {
    if( ThreadRegistry::_uniqueRegistry == NULL )
      {
	ThreadRegistry::_uniqueRegistry = new ThreadRegistry();
      }
    if((ThreadRegistry::_uniqueRegistry-> _table).find(objID) 
       != (ThreadRegistry::_uniqueRegistry-> _table).end())
      throw new SameNameBindedException("ThreadRegistry::add( DString Thread *) "+String::digitToString(objID));
     
    (ThreadRegistry::_uniqueRegistry-> _table).insert(std::pair<DLong,Thread*>(objID,obj));
  }
  
  void ThreadRegistry::del( const DLong& objID )
      throw( ThreadNotFoundException * )
  {
    if( ThreadRegistry::_uniqueRegistry == NULL )
      throw new ThreadNotFoundException("ThreadRegistry::del( const DString& )"+objID);

    if((ThreadRegistry::_uniqueRegistry-> _table).find(objID) 
       == (ThreadRegistry::_uniqueRegistry-> _table).end())
      throw new ThreadNotFoundException("ThreadRegistry::del( const DString& )"+objID);
    
    ((ThreadRegistry::_uniqueRegistry->_table).find( objID )->second)=NULL;
    (ThreadRegistry::_uniqueRegistry->_table).erase( objID );
  }
  
  void ThreadRegistry::shutdown()
  { 
    for( std::map< DLong , Thread *> :: iterator iter= (ThreadRegistry::_uniqueRegistry-> _table).begin() ; 
	 iter != (ThreadRegistry::_uniqueRegistry-> _table).end() ; 
	 iter++)
      {
	      try{
		      ((Thread*)iter->second)->exit();
	      }catch(Exception * e ){
		     std::cerr<< e << std::endl;
		     delete e;
	      }
      }
  }
  ThreadRegistry* ThreadRegistry::getRegistry()
  {
    if( ThreadRegistry::_uniqueRegistry == NULL )
	ThreadRegistry::_uniqueRegistry = new ThreadRegistry();
    return ThreadRegistry::_uniqueRegistry;
  }
  Thread* ThreadRegistry::getThread( const DLong& objID )
    throw( ThreadNotFoundException * )
  {
    std::map< DLong, Thread* >::iterator iter
      = (ThreadRegistry::_uniqueRegistry->_table).find( objID );
    if( iter == (ThreadRegistry::_uniqueRegistry->_table).end()) 
      throw new ThreadNotFoundException("ThreadRegistry::getThread( const DString& )"+objID);
      
    return (Thread*)(iter -> second);
  }
  void ThreadRegistry::clear()
  {
    (ThreadRegistry::_uniqueRegistry->_table).clear();
  }
  ThreadRegistry& ThreadRegistry::operator =(const ThreadRegistry& right )
  {
    *((Object*)this) =       *((Object*)&right);
    return *this;
  }
  DBool   ThreadRegistry::operator   ==(const ThreadRegistry & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   ThreadRegistry::operator   !=(const ThreadRegistry & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
}
