#ifndef __DAQBuilderThreadRegistory_HH__
#define __DAQBuilderThreadRegistory_HH__
#include <Exception/DAQBuilderThreadNotFoundException.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>

namespace DAQBuilder
{
  class Thread;
  class ThreadRegistry : public Object
  {
  private : 
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
    static   ThreadRegistry *                  _uniqueRegistry;
    explicit ThreadRegistry();
  public :
    virtual  const DString toString() const ;
    std::map< DLong , Thread* >  _table;
    ~ThreadRegistry();
    static ThreadRegistry* getRegistry();
    static void add( const DLong& objID , Thread * obj )
      throw( SameNameBindedException * );
    static void del( const DLong& objID )
      throw( ThreadNotFoundException * );
    static void shutdown() ;
    static Thread* getThread( const DLong& objID ) 
      throw( ThreadNotFoundException * );
    static void clear();
  public:
    ThreadRegistry& operator   =(const ThreadRegistry & right );
    virtual DBool   operator   ==(const ThreadRegistry& right ) const ;
    virtual DBool   operator   !=(const ThreadRegistry& right ) const ;
  };
  inline   ThreadRegistry::ThreadRegistry()
  {
    _setType();
    _setParentClasses();
  }
  inline   ThreadRegistry::~ThreadRegistry()
  {
    this -> _finalize();
  }
  inline void ThreadRegistry::_setType()
  {
    this -> _type = "ThreadRegistry";
  }
  inline void ThreadRegistry::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
}
#endif
