#include <System/DAQBuilderTimestamp.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  const  DString           Timestamp::toString() const 
  {
    DString aString;
    aString = asctime(&_timeStructure);
    aString.erase(aString.length()-1);
    aString+=" +";
    aString+=String::digitToString((DULong)_millis);
    aString+="milisec";
    return aString;
  }
  DBool             Timestamp::after( const Timestamp& right)
  {
    return compareTo(right) == (DByte)ctBig;
  }
  DBool             Timestamp::before( const Timestamp& right)
  {
    return compareTo(right) == (DByte)ctSmall;
  }
  DByte             Timestamp::compareTo( const Timestamp& right )
  {
   return compareTo(&right);
  }
  DByte             Timestamp::compareTo( const Object * right )
  {
    DByte aByte=(DByte)ctUnknown;
    if(!findParent(_type,right))
      return aByte;
    if( _time == ((Timestamp*)right) -> _time )
      return (DByte)ctEquals;
    else if( _time < ((Timestamp*)right) -> _time )
      return (DByte)ctBig;
    else if( _time > ((Timestamp*)right) -> _time )
      return (DByte)ctSmall;
    return aByte;
  }
  DBool             Timestamp::equals( const Timestamp& right )
  {
    return compareTo(right) == (DByte)ctEquals;
  }
  DBool             Timestamp::equals( const Object * right )    
  {
    return compareTo(right) == (DByte)ctEquals;
  }
  DBool   Timestamp::operator   ==(const Timestamp & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   Timestamp::operator   !=(const Timestamp & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
  
  const DULong&      Timestamp::getTime() const 
  {
    return _time;
  }
  void              Timestamp::setTime( const DULong& _time ) 
  {
    this -> _time  = _time;
    _millis = _time % 1000;
    bzero(&_timeStructure,sizeof(_timeStructure));
    time_t now =(time_t)(_time/1000);
    bcopy(localtime(&now),&_timeStructure,sizeof(_timeStructure));
  }
  
  DInt              Timestamp::getYear()
  {
    return _timeStructure.tm_year;
  }
  void              Timestamp::setYear(const DInt & year )
  {
    _timeStructure.tm_year = (int)year;
  }
  DInt              Timestamp::getMonth()
  {
    return _timeStructure.tm_mon;
  }
  void              Timestamp::setMonth(const DInt & month )
  {
    _timeStructure.tm_mon = (int)month;
  }
  DInt              Timestamp::getHour()
  {
    return _timeStructure.tm_hour;
  }
  void              Timestamp::setHour(const DInt & hour )
  {
    _timeStructure.tm_hour = (int)hour;
  }
  DInt              Timestamp::getMinute()
  {
    return _timeStructure.tm_min;
  }
  void              Timestamp::setMinute(const DInt & minute )
  {
    _timeStructure.tm_min =(int)minute;
  }
  DInt              Timestamp::getSecond()
  {
    return _timeStructure.tm_sec;
  }
  void              Timestamp::setSecond(const DInt & second )
  {
    _timeStructure.tm_sec=(int)second;
  }
  DInt              Timestamp::getMillis()
  {
    return _millis;
  }
  void              Timestamp::setMillis(const DInt & millis )
  {
    _millis=millis;
  }
  
  Timestamp::Timestamp( const DULong     & time )
    :Object(),_time(time)
  {
    _millis = _time % 1000;
    bzero(&_timeStructure,sizeof(_timeStructure));
    time_t now =(time_t)(_time/1000);
    bcopy(localtime(&now),&_timeStructure,sizeof(_timeStructure));
    _setType();
    _setParentClasses();
  }
  Timestamp::Timestamp( const Timestamp& right )
    :Object(*((Object*)&right)),_time(right._time),_timeStructure(right._timeStructure),_millis(right._millis)
  {
  }
  Timestamp::~Timestamp()
  {
    _finalize();
  }
  
  Timestamp& Timestamp::operator=(const Timestamp & right )
  {
    *((Object*)this) = *((Object*)&right);
    _time = right._time;
    bcopy(&right._timeStructure,&_timeStructure,sizeof(right._timeStructure));
    _millis=right._millis;
    return *this;
  }
}
