#ifndef __DAQBuilderTimestamp_HH__
#define __DAQBuilderTimestamp_HH__
#include <DAQBuilderObject.hh>
#include <Interface/DAQBuilderComparable.hh>
#include <System/DAQBuilderSystem.hh>
namespace DAQBuilder
{
  class Timestamp : public Object , public Comparable
  {
  private:
    DULong                   _time;
    struct tm                _timeStructure;
    DUShort                  _millis;
  private:
    void                     _setType();
    void                     _setParentClasses();
  public:
    const  DString           toString() const ;
  public:
    DBool             after( const Timestamp& right);
    DBool             before( const Timestamp& right);
    DByte             compareTo( const Timestamp& right );
    DByte             compareTo( const Object * right );
    DBool             equals( const Timestamp& right );
    DBool             equals( const Object * right );
  public:
    const DULong&     getTime() const ;
    void              setTime( const DULong& _time );
  public:
    DInt              getYear();
    void              setYear(const DInt & year );
    DInt              getMonth();
    void              setMonth(const DInt & month );
    DInt              getHour();
    void              setHour(const DInt & hour );
    DInt              getMinute();
    void              setMinute(const DInt & minute );
    DInt              getSecond();
    void              setSecond(const DInt & second );
    DInt              getMillis();
    void              setMillis(const DInt & millis );
  public :
    Timestamp( const DULong    & _time  = System::currentTimeMillis() );
    Timestamp( const Timestamp& right );
    ~Timestamp();
  public:    
    Timestamp& operator   =(const Timestamp & right );
    virtual DBool   operator   ==(const Timestamp& right ) const ;
    virtual DBool   operator   !=(const Timestamp& right ) const ;
  };
  inline void   Timestamp::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   Timestamp::_setType()
  {
    this -> _type = "Timestamp";
  }
}
#endif
