#include <System/IO/DAQBuilderAbstructFile.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
    const  DString                  AbstructFile::toString() const 
    {
	DString aString;
	aString += String::digitToString((DLong)_fd);
	aString += " is ";
	if(isFile()){
	    aString += " File";
	}else if(isDirectory()){
	    aString += " Directory";
	}else if(isCharacterDevice()){
	    aString += " CharacterDevice";
	}else if(isBlockDevice()){
	    aString += " BlockDevice";
	}else if(isFIFO()){
	    aString += " FIFO";
	}else if(isSymbolicLink()){
	    aString += " SymbolicLink";
	}else if(isSocket()){
	    aString += " Socket";
	}
	return aString;
    }
    AbstructFile::AbstructFile( const FileDescriptor& fd  )
	:Object(),_fd(fd)
    {
	_setType();
	_setParentClasses();
    }
    AbstructFile::AbstructFile( const AbstructFile& right )
	:Object(*((Object*)&right)),_fd(right._fd)
    {
    }
    AbstructFile::~AbstructFile()
    {
    }
    AbstructFile& AbstructFile::operator   =(const AbstructFile & right )
    {
	*((Object*)this) = *((Object*)&right);
	_fd              = right._fd;
	return *this;
    }
    DBool    AbstructFile::operator  ==(const AbstructFile & right ) const 
    {
	DBool aBool = *((Object*)this) == *((Object*)&right);
	aBool      |= _fd              == right._fd;
	return aBool;
    }
    DBool    AbstructFile::operator  !=(const AbstructFile & right ) const 
    {
	DBool aBool = *((Object*)this) != *((Object*)&right);
	aBool      |= _fd              != right._fd;
	return aBool;
    }
    DBool    AbstructFile::isFile()    const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISREG(aStat.st_mode) ;
    }
    DBool    AbstructFile::isDirectory() const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISDIR(aStat.st_mode) ;
    }
    DBool    AbstructFile::isCharacterDevice() const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISCHR(aStat.st_mode) ;
    }
    DBool    AbstructFile::isBlockDevice() const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISBLK(aStat.st_mode) ;
    }
    DBool    AbstructFile::isFIFO() const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISFIFO(aStat.st_mode) ;
    }
    DBool    AbstructFile::isSymbolicLink() const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISLNK(aStat.st_mode) ;
    }
    DBool    AbstructFile::isSocket() const
    {
      struct stat aStat ; 
      ::bzero(&aStat, sizeof(aStat));
      if(fstat(_fd,&aStat)!=0) 
        return false;
      return S_ISSOCK(aStat.st_mode) ;
    }
}
