#ifndef __DAQBuilderAbstructFile_HH__
#define __DAQBuilderAbstructFile_HH__ 
#include <DAQBuilderObject.hh>

namespace DAQBuilder
{
  class AbstructFile : public Object
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public:
    const  DString                  toString() const ;
  protected:
    FileDescriptor                  _fd;
  public:
    AbstructFile( const FileDescriptor& _fd );
    AbstructFile( const AbstructFile& right );
    ~AbstructFile();
  public:    
    virtual AbstructFile& operator   =(const AbstructFile & right );
    virtual DBool    operator  ==(const AbstructFile & right ) const ;
    virtual DBool    operator  !=(const AbstructFile & right ) const ;
  public:
    virtual DBool    isFile()    const;
    virtual DBool    isDirectory() const;
    virtual DBool    isCharacterDevice() const;
    virtual DBool    isBlockDevice() const;
    virtual DBool    isFIFO() const;
    virtual DBool    isSymbolicLink() const;
    virtual DBool    isSocket() const;
  };
  inline void   AbstructFile::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   AbstructFile::_setType()
  {
    this -> _type = "AbstructFile";
  }
}
#endif
