#include <System/IO/DAQBuilderBufferedInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            BufferedInputStream::_finalize()
  {
//    _bufferQueue.clear();
  }


  const  DString                  BufferedInputStream::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString += "Available Size : ";
    aString += String::digitToString(available());
    if(!_inputStream.isNull()){
    aString += "\n";
    aString += _inputStream->toString();
}  
    //aString += _toStringFooter();
    return aString;
  }
  /*DULong                  BufferedInputStream::available()  const 
  {
    return (DULong)(_bufferQueue.size());
  }*/
  void  BufferedInputStream::_getNextData()
    throw( Exception * )
  {
    DByte *  aBuf       = new DByte[_bufferSize];

    DULong aReadSize    = ((InputStream*)_inputStream.get())->read(aBuf,_bufferSize);
    
    std::copy(aBuf,aBuf+aReadSize,std::back_inserter(_bufferQueue));
    delete [] aBuf;
  }
  void  BufferedInputStream::mark()
  {
    ((InputStream*)_inputStream.get()) -> mark();
  }                       
  DBool BufferedInputStream::markSupported()
  {
    return ((InputStream*)_inputStream.get()) -> markSupported();
  }              
  DULong  BufferedInputStream::read( DByte * buf , DULong size )
    throw(Exception*)
  {
    DULong i ;
    for( i = 0 ; i < size  ; i ++ )
      {
	if(_bufferQueue.empty())
          _getNextData();

	if(_bufferQueue.empty() && ((InputStream*)_inputStream.get()) -> isEOF()){
          _isEOF = true; 
          break;
         }

        buf[i]=_bufferQueue.front();
	_bufferQueue.pop_front();
      }
    return i;
  }
  void  BufferedInputStream::reset()                      
    throw(IOException*)
  {
   ((InputStream*)_inputStream.get()) -> reset(); 
    _isEOF =   ((InputStream*)_inputStream.get()) -> isEOF();
  }

  DLong BufferedInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    DLong     numSkip = ((InputStream*)_inputStream.get()) -> skip(nSkip);
    _isEOF = ((InputStream*)_inputStream.get()) -> isEOF();
    return   numSkip ;
  }

  void  BufferedInputStream::close()
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> close();
  }
  BufferedInputStream::BufferedInputStream( InputStream * inputStream ,
					              const DULong& bufferSize)
    :FilterInputStream(inputStream),_bufferSize(bufferSize)
  {
    _setType();
    _setParentClasses();
  }
  BufferedInputStream::BufferedInputStream( const BufferedInputStream& right ) 
    :FilterInputStream(*((FilterInputStream*)&right)),_bufferQueue(right._bufferQueue),
     _bufferSize(right._bufferSize)
  {
    _setType();
    _setParentClasses();
  }
  BufferedInputStream::~BufferedInputStream()
  {
    _finalize();
  }
  BufferedInputStream& BufferedInputStream::operator   =(const BufferedInputStream & right )
  {
    *((FilterInputStream*)this) =       *((FilterInputStream*)&right);
    _bufferQueue = right._bufferQueue;
    _bufferSize  = right._bufferSize;
    return *this;
  }
}
