#ifndef __DAQBuilderBufferedInputInputStream_HH__
#define __DAQBuilderBufferedInputInputStream_HH__
#include <System/IO/DAQBuilderFilterInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class BufferedInputStream : public FilterInputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    std::list<DByte>                _bufferQueue;
    DULong                          _bufferSize;
  protected:
    virtual void  _getNextData()
      throw( Exception * );
  public:
//    virtual DULong available() const ;                       
    virtual void  mark();                       
    virtual DBool markSupported();              
    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    BufferedInputStream( InputStream * _inputStream , const DULong& _bufferSize = 1024 );
    BufferedInputStream( const BufferedInputStream& right );
    ~BufferedInputStream();
  public:    
    BufferedInputStream& operator   =(const BufferedInputStream & right );
  };
  inline void   BufferedInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
  }
  inline void   BufferedInputStream::_setType()
  {
    this -> _type = "BufferedInputStream";
  }
}
#endif
