#include <System/IO/DAQBuilderBufferedOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            BufferedOutputStream::_finalize()
  { 
    flush();
  }

  const  DString                  BufferedOutputStream::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString += "MaxBufferSize : ";
    aString += String::digitToString((DULong)_maxBufferSize);
    aString += "\n";
    aString += "BufferSize    : ";
    aString += String::digitToString((DULong)_buffer.size());
    if(!_outputStream.isNull()){
    aString += "\n";
    aString += _outputStream -> toString();
    }
    //aString += _toStringFooter();
    return aString;
  }

  void  BufferedOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    DULong i;
    for( i = 0 ; i < size ; i ++)
    { 
      if(isFull())
       flush();
      _buffer.push_back(buffer[i]);
    }
  }
  void  BufferedOutputStream::flush()
    throw(IOException*)
  {
    if(!_buffer.empty())
     ((OutputStream*)_outputStream.get()) -> write(&_buffer[0],_buffer.size());
    ((OutputStream*)_outputStream.get()) -> flush();
    _buffer.clear();
  }
  void  BufferedOutputStream::close()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get()) -> close();
  }
  BufferedOutputStream::BufferedOutputStream( OutputStream * outputStream , const DULong & maxBufferSize)
    :FilterOutputStream(outputStream),_maxBufferSize(maxBufferSize)
  {
    _setType();
    _setParentClasses();
  }
  BufferedOutputStream::BufferedOutputStream( const BufferedOutputStream& right ) 
    :FilterOutputStream(*((FilterOutputStream*)&right)),_buffer(right._buffer),
    _maxBufferSize(right._maxBufferSize)
  {
    _setType();
    _setParentClasses();
  }
  BufferedOutputStream::~BufferedOutputStream()
  {
   _finalize();
  }
  BufferedOutputStream& BufferedOutputStream::operator   =(const BufferedOutputStream & right )
  {
    *((FilterOutputStream*)this) =       *((FilterOutputStream*)&right);
    _buffer       =right._buffer;
    _maxBufferSize=right._maxBufferSize;
    return *this;
  }
}
