#ifndef __DAQBuilderBufferedOutputStream_HH__
#define __DAQBuilderBufferedOutputStream_HH__
#include <System/IO/DAQBuilderFilterOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class BufferedOutputStream : public FilterOutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    ByteArray                       _buffer;
    DULong                          _maxBufferSize;
  public:
    virtual void  flush()
      throw(IOException*);

    virtual void  write( DByte[] , DULong size )
      throw(Exception*);
    virtual void  close()
      throw(IOException*);
    virtual DBool  isFull() const ;
  public :
    BufferedOutputStream( OutputStream * _outputStream , const DULong& _maxBufferSize=10240);
    BufferedOutputStream( const BufferedOutputStream& right );
    ~BufferedOutputStream();
  public:    
    BufferedOutputStream& operator   =(const BufferedOutputStream & right );
  };
  inline void   BufferedOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
  }
  inline void   BufferedOutputStream::_setType()
  {
    this -> _type = "BufferedOutputStream";
  }
  inline DBool  BufferedOutputStream::isFull() const 
  {
    return (_buffer.size() >= _maxBufferSize)?true:false;
  }
}
#endif
