#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
 void                            ByteArrayInputStream::_finalize() 
  {
    _byteArray.clear();
    _currentPosition=0;
    _markedPosition =-1;
  }

  const  DString                  ByteArrayInputStream::toString() const 
  {
    DString aString ; //= _toStringHeader();
    aString += "AvailableSize : ";
    aString += String::digitToString(available());
    aString += "\n";
    //aString += _toStringFooter();
    return aString;
  }

  void  ByteArrayInputStream::mark()
  {
    _markedPosition = _currentPosition;
  }
  DBool ByteArrayInputStream::markSupported()
  {
    return true;
  }
  DULong ByteArrayInputStream::available() const 
  {
    if( (_byteArray.size() - _currentPosition )< 0 )
        return 0;
    return (DULong)( _byteArray.size() - _currentPosition );
  }


  DULong  ByteArrayInputStream::read( DByte* buffer , DULong size )
    throw(Exception*)
  {
    DULong i ;
    for( i = 0 ; i < size ; i++ , _currentPosition++)
      {
        if( available() == 0 ){
          _isEOF = true;
	  break;
        }
        buffer[i] = _byteArray[_currentPosition];
      }
    return i; 
    //size == i ? std::cout<<"Size OK" <<std::endl :  std::cout<<"Size Illegal i "<<i<<" size "<<size<<std::endl;
  }
  void  ByteArrayInputStream::reset()                      
    throw(IOException*)
  {
    _currentPosition=_markedPosition;
    _isEOF = false;
  }
  DLong ByteArrayInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    DLong i;
    for( i = 0 ; i < nSkip ; i++ , _currentPosition++)
      {
        if( available() == 0 ){
          _isEOF = true;
	  break;
         }
      } 
    return i;
  }
  void  ByteArrayInputStream::close()
    throw(IOException*)
  {
   _byteArray.clear();
  }
  ByteArrayInputStream::ByteArrayInputStream( const ByteArray& byteArray )
    :InputStream(),_byteArray( byteArray ),
     _currentPosition(0),_markedPosition(-1)
  {
    _setType();
    _setParentClasses();
  }
  ByteArrayInputStream::ByteArrayInputStream( const DByte* byteArray ,
                                              const DULong& byteArraySize )
    :InputStream(),//_byteArray( byteArray ),
     _currentPosition(0),_markedPosition(-1)
  {
    _setType();
    _setParentClasses();
    _byteArray.clear();
    std::copy(byteArray,byteArray+byteArraySize,std::back_inserter(_byteArray));
    //std::cout<<"ByteArraySize :"<<_byteArray.size()<<std::endl;
  }
  ByteArrayInputStream::ByteArrayInputStream( const ByteArrayInputStream& right ) 
    :InputStream(*((InputStream*)&right)),_byteArray(right._byteArray),
     _currentPosition(right._currentPosition),_markedPosition(right._markedPosition)
  {
    _setType();
    _setParentClasses();
  }
  ByteArrayInputStream::~ByteArrayInputStream()
  {
    _finalize();
  }
  ByteArrayInputStream& ByteArrayInputStream::operator   =(const ByteArrayInputStream & right )
  {
    *((InputStream*)this) =       *((InputStream*)&right);
    _byteArray = right._byteArray;
    _currentPosition = right._currentPosition;
    _markedPosition  = right._markedPosition;
    return *this;
  }
}
