#ifndef __DAQBuilderByteArrayInputStream_HH__
#define __DAQBuilderByteArrayInputStream_HH__
#include <System/IO/DAQBuilderInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class ByteArrayInputStream : public InputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    ByteArray                       _byteArray;
    DInt                            _currentPosition;
    DInt                            _markedPosition;
  public:
    virtual DULong available() const ;
    virtual void  mark();
    virtual DBool markSupported();
    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    ByteArrayInputStream( const ByteArray& byteArray );
    ByteArrayInputStream( const DByte *  byteArray , const DULong& byteArraySize  );
    ByteArrayInputStream( const ByteArrayInputStream& right );
    ~ByteArrayInputStream();
  public:    
    ByteArrayInputStream& operator   =(const ByteArrayInputStream & right );
  };
  inline void   ByteArrayInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
  }
  inline void   ByteArrayInputStream::_setType()
  {
    this -> _type = "ByteArrayInputStream";
  }
}
#endif
