#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            ByteArrayOutputStream::_finalize()
  {
    _byteArray.clear();
    _append=false;
  }

  const  DString                  ByteArrayOutputStream::toString() const 
  {
    DString aString ;//= _toStringHeader();
    //aString += _toStringFooter();
    return aString;
  }

  void  ByteArrayOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    std::copy(buffer,buffer+size,std::back_inserter(_byteArray));
  }
  void  ByteArrayOutputStream::write( const ByteArray& buffer )
    throw(Exception*)
  {
    std::copy(buffer.begin(),buffer.end(),std::back_inserter(_byteArray));
  }
  void ByteArrayOutputStream::flush()
    throw(IOException*)
  {;}

  void  ByteArrayOutputStream::writeTo( OutputStream* out  )
    throw(Exception*)
  {
    //DByte * b = new DByte[ _byteArray.size() ];
    //std::copy(_byteArray.begin(),_byteArray.end(),b);
    //out->write(b,_byteArray.size());
    if(!_byteArray.empty())
    out->write(&_byteArray[0],_byteArray.size());
    //delete [] b;
  }
  void  ByteArrayOutputStream::close()
    throw(IOException*)
  {
   _byteArray.clear();
  }
  ByteArray ByteArrayOutputStream::toByteArray() const 
  { 
    return _byteArray;
  }
  void      ByteArrayOutputStream::toByteArray( DByte *& byteArray , DULong & byteArraySize ) const 
  { 
    if(_byteArray.size() <= byteArraySize )
    {
      std::copy(_byteArray.begin(),_byteArray.end(),byteArray);
      byteArraySize = _byteArray.size();
     }
     else 
     {
       ByteArray::const_iterator iter = _byteArray.begin(); 
       std::copy(iter,iter+byteArraySize,byteArray);
     }
  }
  const DULong  ByteArrayOutputStream::getSize() const 
  {
    return (DULong)_byteArray.size();
  }
  ByteArrayOutputStream::ByteArrayOutputStream( const DBool& append)
    :OutputStream(),_byteArray( ByteArray() ),_append(append)
  {
    _setType();
    _setParentClasses();
  }

  ByteArrayOutputStream::ByteArrayOutputStream( const ByteArrayOutputStream& right ) 
    :OutputStream(*((OutputStream*)&right))
  {
    _setType();
    _setParentClasses();
    if(_append)
      {
	for(ByteArray::const_iterator iter = right._byteArray.begin();
	    iter                          != right._byteArray.end();
            iter++
	    )
	  _byteArray.push_back(*iter);
      }
    else
      _byteArray=right._byteArray;
    _append = right._append;
  }

  ByteArrayOutputStream::~ByteArrayOutputStream()
  {
    _finalize();
  }

  ByteArrayOutputStream& ByteArrayOutputStream::operator   =(const ByteArrayOutputStream & right )
  {
    *((OutputStream*)this) =       *((OutputStream*)&right);
    if(_append)
      {
	for(ByteArray::const_iterator iter = right._byteArray.begin();
	    iter                          != right._byteArray.end();
            iter++
	    )
	  _byteArray.push_back(*iter);
      }
    else
      _byteArray=right._byteArray;
    _append    = right._append;
    return *this;
  }
}
