#ifndef __DAQBuilderByteArrayOutputStream_HH__
#define __DAQBuilderByteArrayOutputStream_HH__
#include <System/IO/DAQBuilderOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class ByteArrayOutputStream : public OutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    ByteArray                       _byteArray;
    DBool                           _append;
  public:
    virtual void  flush()
      throw(IOException*);

    virtual void  write( DByte* buffer , DULong size )
      throw(Exception*);
    virtual void  write( const ByteArray& buffer  )
      throw(Exception*);
    virtual void  writeTo( OutputStream* out  )
      throw(Exception*);

    virtual void  close()
      throw(IOException*);
    
    virtual ByteArray toByteArray() const ;
    virtual void      toByteArray( DByte *& byteArray, DULong & byteArraySize ) const ;
    virtual const DULong  getSize() const ;
  public :
    ByteArrayOutputStream( const DBool& _append = false );
    ByteArrayOutputStream( const ByteArrayOutputStream& right );
    ~ByteArrayOutputStream();
  public:    
    ByteArrayOutputStream& operator   =(const ByteArrayOutputStream & right );
  };
  inline void   ByteArrayOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
  }
  inline void   ByteArrayOutputStream::_setType()
  {
    this -> _type = "ByteArrayOutputStream";
  }
}
#endif
