#include <DAQBuilderSerializableObject.hh>
#include <System/IO/DAQBuilderCheckedInputStream.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Exception/DAQBuilderDisagreementOfTypeException.hh>

namespace DAQBuilder
{
  void                            CheckedInputStream::_finalize()
  {;}

  ElementType  CheckedInputStream::_readType()
    throw(Exception*)
  {
    return (ElementType) ((PrimitiveDataInputStream*)this)->readShort(); 
  }

  SerializableObject* CheckedInputStream::_readObject()
    throw(Exception*)
  {
    DString aObjectTypeName  = ((PrimitiveDataInputStream*)this)->readString(); 
    DULong  aObjectSize      = ((PrimitiveDataInputStream*)this)->readULong();
    DByte  * aBuf            = new DByte[ aObjectSize ];
    
    read( aBuf , aObjectSize );
    
    SerializableObject * returnObject =
      SerializableObjectLoader::getObject( aObjectTypeName );
    
    returnObject -> unSerialize( aBuf , aObjectSize );
    
    delete [] aBuf;
    return returnObject;
  }
  const  DString                  CheckedInputStream::toString() const 
  {
    DString aString;// = _toStringHeader();
    aString += "AvailableSize  : ";
    aString += String::digitToString(available());
    aString += "\n";
    //aString += _toStringFooter();
    return aString;
  }

  void  CheckedInputStream::mark()
  {
    if(markSupported())
      ((InputStream*)_inputStream.get()) -> mark();
  }
/*  DULong CheckedInputStream::available() const 
  {
    return _inputStream -> available();
  }*/
  DBool CheckedInputStream::markSupported()
  {
    return ((InputStream*)_inputStream.get()) -> markSupported();

  }

  DULong  CheckedInputStream::read( DByte* buffer , DULong size )
    throw(Exception*)
  {
    DULong numRead = ((InputStream*)_inputStream.get()) -> read(buffer,size);
      _isEOF =((InputStream*)_inputStream.get()) -> isEOF() ;
    return numRead;
  }
  DChar CheckedInputStream::readChar()
    throw(Exception*)
  {
    if(etChar != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal") ;
       e -> insert("Location"," CheckedInputStream::readChar()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readChar();
  }
  DBool  CheckedInputStream::readBool()
    throw(Exception*)
  {
    if(etBool != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readBool()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readBool();
  }
  DByte  CheckedInputStream::readByte()
    throw(Exception*)
  {
    if(etByte != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readByte()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readByte();
  }
  DInt  CheckedInputStream::readInt()
    throw(Exception*)
  {
    if(etInt != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readInt()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readInt();
  }
  DUInt  CheckedInputStream::readUInt()
    throw(Exception*)
  {
    if(etUInt != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readUInt()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readUInt();
  }
  DLong  CheckedInputStream::readLong()
    throw(Exception*)
  {
    if(etLong != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readLong()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readLong();
  }
  DULong  CheckedInputStream::readULong()
    throw(Exception*)
  {
    if(etULong != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readULong()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readULong();
  }
  DShort  CheckedInputStream::readShort()
    throw(Exception*)
  {
    if(etShort != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readShort()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readShort();
  }
  DUShort  CheckedInputStream::readUShort()
    throw(Exception*)
  {
    if(etUShort != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readUShort()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readUShort();
  }
  DString CheckedInputStream::readString()
    throw(Exception*)
  {
    if(etString!= _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readString()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readString();
  }
  DDouble CheckedInputStream::readDouble()
     throw(Exception*)
  {
    if(etDouble!= _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readDouble()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readDouble();
  }
  DFloat CheckedInputStream::readFloat()
     throw(Exception*)
  {
    if(etFloat!= _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readFloat()");
       throw e;
    }
    return ((PrimitiveDataInputStream*)this)->readFloat();
  }

  SerializableObject* CheckedInputStream::readObject()
    throw(Exception*)
  {
    if(etSObject != _readType()){
       DisagreementOfTypeException * e = new DisagreementOfTypeException("TypeIllegal"); 
       e -> insert("Location"," CheckedInputStream::readSObject()");
       throw e;
    }
    return _readObject();
  }

  void  CheckedInputStream::reset()                      
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> reset();
  }
  DLong CheckedInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    DLong numSkip =((InputStream*)_inputStream.get()) -> skip(nSkip);
    _isEOF =((InputStream*)_inputStream.get()) -> isEOF();
    return  numSkip;
  }
  void  CheckedInputStream::close()
    throw(IOException*)
  {
    ((InputStream*)_inputStream.get()) -> close();
  }
  CheckedInputStream::CheckedInputStream( InputStream * inputStream )
    :ObjectInputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  CheckedInputStream::CheckedInputStream( const CheckedInputStream& right ) 
    :ObjectInputStream(*((ObjectInputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  CheckedInputStream::~CheckedInputStream()
  {
    _finalize();
  }
  CheckedInputStream& CheckedInputStream::operator   =(const CheckedInputStream & right )
  {
    *((ObjectInputStream*)this) =       *((ObjectInputStream*)&right);
    return *this;
  }
}
