#ifndef __DAQBuilderCheckedInputStream_HH__
#define __DAQBuilderCheckedInputStream_HH__
#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class CheckedInputStream : public ObjectInputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    virtual ElementType _readType()
      throw(Exception*);
    virtual SerializableObject * _readObject()
      throw(Exception*);
  public:
    virtual void  mark();
//    virtual DULong available() const ;
    virtual DBool markSupported();

    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*);
    virtual DChar  readChar()
      throw(Exception*);
    virtual DBool  readBool()
      throw(Exception*);
    virtual DByte  readByte()
      throw(Exception*);
    virtual DInt  readInt()
      throw(Exception*);
    virtual DUInt  readUInt()
      throw(Exception*);
    virtual DLong  readLong()
      throw(Exception*);
    virtual DULong  readULong()
      throw(Exception*);
    virtual DShort readShort()
      throw(Exception*);
    virtual DUShort readUShort()
      throw(Exception*);
    virtual DDouble readDouble()
      throw(Exception*);
    virtual DFloat readFloat()
      throw(Exception*);
    virtual DString readString()
      throw(Exception*);
    virtual SerializableObject* readObject()
      throw(Exception*); 

    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    CheckedInputStream( InputStream * _inputStream);
    CheckedInputStream( const CheckedInputStream& right );
    ~CheckedInputStream();
  public:    
    CheckedInputStream& operator   =(const CheckedInputStream & right );
  };
  inline void   CheckedInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
    _parentClasses.insert("FilterInputStream");
    _parentClasses.insert("PrimitiveDataInputStream");
    _parentClasses.insert("ObjectInputStream");
  }
  inline void   CheckedInputStream::_setType()
  {
    this -> _type = "CheckedInputStream";
  }
}
#endif
