#include <System/IO/DAQBuilderCheckedOutputStream.hh>
#include <DAQBuilderSerializableObject.hh>

namespace DAQBuilder
{
  const  DString                  CheckedOutputStream::toString() const 
  {
    DString aString ;
    if(!_outputStream.isNull())
      aString += _outputStream->toString();
    return aString;
  }
  void  CheckedOutputStream::flush()
    throw(IOException*)
  { 
    ((OutputStream*)_outputStream.get()) -> flush();
  }
  void  CheckedOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    ((OutputStream*)_outputStream.get()) -> write(buffer,size);
  }
  void CheckedOutputStream::write( const DChar &  c )
    throw(Exception*)
  {
    writeShort((DShort)etChar);
    writeChar(c);
    return ;
  }
  void  CheckedOutputStream::write( const DBool& c )
    throw(Exception*)
  {
    writeShort((DShort)etBool);
    writeBool(c);
  }

  void  CheckedOutputStream::write(const DByte& c )
    throw(Exception*)
  {
    writeShort((DShort)etByte);
    writeByte(c);
  }
  void  CheckedOutputStream::write( const DInt& c)
    throw(Exception*)
  {
    writeShort((DShort)etInt);
    writeInt(c);
  }
  void  CheckedOutputStream::write( const DUInt& c)
    throw(Exception*)
  {
    writeShort((DShort)etUInt);
    writeUInt(c);
  }
  void  CheckedOutputStream::write(const DLong& c)
    throw(Exception*)
  {
    writeShort((DShort)etLong);
    writeLong(c);
  }
  void  CheckedOutputStream::write(const DULong& c)
    throw(Exception*)
  {
    writeShort((DShort)etULong);
    writeULong(c);
  }
  void  CheckedOutputStream::write(const DShort& c )
    throw(Exception*)
  {
    writeShort((DShort)etShort);
    writeShort(c);
  }
  void  CheckedOutputStream::write(const DUShort& c )
    throw(Exception*)
  {
    writeShort((DShort)etUShort);
    writeUShort(c);
  }
  void CheckedOutputStream::write( const DDouble & s )
      throw(Exception*)
   {
    writeShort((DShort)etDouble);
    writeDouble(s);
   }
  void CheckedOutputStream::write( const DFloat & s )
      throw(Exception*)
   {
    writeShort((DShort)etFloat);
    writeFloat(s);
   }
  void CheckedOutputStream::write( const DString& str)
    throw(Exception*)
  {
    writeShort((DShort)etString);
    writeString(str);
  }

  void CheckedOutputStream::write( SerializableObject& sobj  )
    throw(Exception*)
  {
    writeShort((DShort)etSObject);
    writeObject(sobj);
  }

  void CheckedOutputStream::write( SerializableObject* sobj  )
    throw(Exception*)
  {
    writeShort((DShort)etSObject);
    writeObject(sobj);
  }
  
  void  CheckedOutputStream::close()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get()) -> close();
  }
  CheckedOutputStream::CheckedOutputStream( OutputStream * inputStream )
    :ObjectOutputStream(inputStream)
  {
    _setType();
    _setParentClasses();
  }
  CheckedOutputStream::CheckedOutputStream( const CheckedOutputStream& right ) 
    :ObjectOutputStream(*((ObjectOutputStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
  CheckedOutputStream::~CheckedOutputStream()
  {
    //_finalize();
  }
  CheckedOutputStream& CheckedOutputStream::operator   =(const CheckedOutputStream & right )
  {
    *((ObjectOutputStream*)this) =       *((ObjectOutputStream*)&right);
    return *this;
  }
}
