#ifndef __DAQBuilderCheckedOutputStream_HH__
#define __DAQBuilderCheckedOutputStream_HH__
#include <System/IO/DAQBuilderObjectOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class SerializableObject;
  class CheckedOutputStream : public ObjectOutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  public:
    const  DString                  toString() const ;
  public:
    virtual void  flush()
      throw(IOException*);

    virtual void  write( DByte[] , DULong size )
      throw(Exception*);
    virtual void  write( const DChar & c)
      throw(Exception*);
    virtual void  write( const DBool & b )
      throw(Exception*);
    virtual void  write( const DByte & b )
      throw(Exception*);
    virtual void  write( const DInt & i )
      throw(Exception*);
    virtual void  write( const DUInt & i )
      throw(Exception*);
    virtual void  write( const DLong & l)
      throw(Exception*);
    virtual void  write( const DULong & l)
      throw(Exception*);
    virtual void write( const DShort & s )
      throw(Exception*);
    virtual void write( const DUShort & s )
      throw(Exception*);
    virtual void write( const DDouble & s )
      throw(Exception*);
    virtual void write( const DFloat & s )
      throw(Exception*);
    virtual void write( const DString & str )
      throw(Exception*);
    virtual void write( SerializableObject& sobj  )
      throw(Exception*);
    virtual void write( SerializableObject* sobj  )
      throw(Exception*);

    virtual void  close()
      throw(IOException*);
  public :
    CheckedOutputStream( OutputStream * _outputStream);
    CheckedOutputStream( const CheckedOutputStream& right );
    ~CheckedOutputStream();
  public:    
    CheckedOutputStream& operator   =(const CheckedOutputStream & right );
  };
  inline void   CheckedOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
    _parentClasses.insert("ObjectOutputStream");
  }
  inline void   CheckedOutputStream::_setType()
  {
    this -> _type = "CheckedOutputStream";
  }
}
#endif
