#include <System/DAQBuilderSystem.hh>
#include <System/DAQBuilderCommandLoader.hh>
#include <System/DAQBuilderClassLoader.hh>
#include <System/DAQBuilderObjectRegistry.hh>
#include <System/IO/DAQBuilderCommandOutputStream.hh>
#include <System/IO/DAQBuilderFile.hh>
#include <System/IO/DAQBuilderFileOutputStream.hh>
#include <System/IO/DAQBuilderBufferedOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
   CommandOutputStream::CommandOutputStream( const CommandOutputStream& right ) 
    :PrintStream(*((PrintStream*)&right))
  {
    _setType();
    _setParentClasses();
  }
   CommandOutputStream::~CommandOutputStream()
  {
    //_finalize();
  }
   CommandOutputStream& CommandOutputStream::operator   =(const CommandOutputStream & right )
  {
    *((PrintStream*)this) =       *((PrintStream*)&right);
    return *this;
  }
  DBool  CommandOutputStream::_execute(const DString& input )
  {
     try{
	StringList commandSL  = _divide(input);
        DString commandName   = commandSL[0];
	commandSL.erase(commandSL.begin()); 
        //_lock();
    /*for(DUInt i =  0 ; i < commandSL.size() ;  i++ ){
          System::out.print(String::digitToString((DULong)i));
          System::out.println(commandSL[i]);
}*/
	CommandLoader::execute( commandName , commandSL );
        //_unLock();
    }catch(Exception * e){
      System::err.println(e);
      delete e;
      return false;
      }
        return true;
  }
  StringList  CommandOutputStream::_divide( const DString& source )
  {
    DString input = source.substr(0,source.find_last_not_of(" \n")+1);
    StringList divided;
    
    size_t begin = 0;
    size_t end = 0;
    size_t inputlen = input.size();
    
    
    do {
      begin = input.find_first_not_of( ' ', end );
      end   = input.find( ' ', begin );
      if ( begin < inputlen && end >= inputlen ) {
	divided.push_back( input.substr( begin, inputlen - begin ) );
      } else if ( begin >= inputlen && end >= inputlen ) {
	break;
      } else {
	divided.push_back( input.substr( begin, end - begin ) );
      }
    } while ( begin < inputlen && end < inputlen );
    return divided ;
  }
  CommandOutputStream::CommandOutputStream()
    :PrintStream()
  {
    try{
      _setType();
      _setParentClasses();
      File   aCmdOut("last.dbmac");
      if(!aCmdOut.isExists())
	aCmdOut.createNewFile();
      _outputStream = new BufferedOutputStream( new FileOutputStream(aCmdOut),128);
    }catch(Exception* e){
      std::cerr<<e<<std::endl;
      delete e;
    }
  }
  void CommandOutputStream::print( const DString& str)
    throw(Exception*)
  {
    DString aCommand = str;
    DULong aPrintablePoint;
    for( aPrintablePoint= 0 ; aPrintablePoint < aCommand.size() ; aPrintablePoint ++)
      {  
        if(!isprint(aCommand[aPrintablePoint]) )
	  break;
      }
    if(!aCommand.empty()){
      DString aExecuteCommand = aCommand.substr(0,aPrintablePoint);
 //     DString aExecuteCommand = aCommand;
      DBool result = _execute(aExecuteCommand);
      aExecuteCommand += "\n";
      if(result)
      write(((DByte*)&aExecuteCommand[0]),aPrintablePoint+1);
      //write(((DByte*)&aExecuteCommand[0]),aExecuteCommand.length());
    }
    flush();
  }
}
