#ifndef __DAQBuilderCommandOutputStream_HH__
#define __DAQBuilderCommandOutputStream_HH__
#include <System/IO/DAQBuilderPrintStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class CommandOutputStream : public PrintStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
  protected:
    StringList                      _divide( const DString& input );
    DBool                            _execute( const DString& input );
  public :
    CommandOutputStream(); 
    CommandOutputStream( const CommandOutputStream& right );
    virtual ~CommandOutputStream();
  public:    
    CommandOutputStream& operator   =(const CommandOutputStream & right );
  public: 
    void                             print( const DString& str )
        throw(Exception*);
  };

  inline void   CommandOutputStream::_setType()
  {
    this -> _type = "CommandOutputStream";
  }

  inline void   CommandOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
    _parentClasses.insert("PrintStream");
  }
}
#endif
