#include <System/IO/DAQBuilderDeflaterOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/DAQBuilderDeflater.hh>

namespace DAQBuilder
{
  const  DString                  DeflaterOutputStream::toString() const 
  {
    DString aString = ((Deflater*)_deflater.get())->toString();
    //aString += _toStringFooter();
    return aString;
  }

  void                            DeflaterOutputStream::_finalize()
  { 
  }
  void  DeflaterOutputStream::flush()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get())->flush();
  }
  void  DeflaterOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    ByteArray aByteArray = ((Deflater*)_deflater.get())->compress(buffer,size);
    if(!aByteArray.empty()){
      PrimitiveDataOutputStream aPrimitiveDataOutputStream(((OutputStream*)_outputStream.get()));
      aPrimitiveDataOutputStream.writeULong((DULong)aByteArray.size());
     ((OutputStream*)_outputStream.get()) -> write(&aByteArray[0],aByteArray.size());
     }
  }
  void  DeflaterOutputStream::close()
    throw(IOException*)
  {
    ((OutputStream*)_outputStream.get()) -> close();
  }
  DeflaterOutputStream::DeflaterOutputStream( OutputStream * outputStream ,
					      Deflater     * deflater)
    :FilterOutputStream(outputStream)
  {
    _deflater = deflater;
    _setType();
    _setParentClasses();
  }
  DeflaterOutputStream::DeflaterOutputStream( const DeflaterOutputStream& right ) 
    :FilterOutputStream(*((FilterOutputStream*)&right)),_deflater(right._deflater)
  {
  }
  DeflaterOutputStream::~DeflaterOutputStream()
  {
  //  _finalize();
  }
  DeflaterOutputStream& DeflaterOutputStream::operator   =(const DeflaterOutputStream & right )
  {
    *((FilterOutputStream*)this) =       *((FilterOutputStream*)&right);
    _deflater                    = right._deflater;
    return *this;
  }
}
