#ifndef __DAQBuilderDeflaterOutputStream_HH__
#define __DAQBuilderDeflaterOutputStream_HH__
#include <System/IO/DAQBuilderFilterOutputStream.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class Deflater;
  class DeflaterOutputStream : public FilterOutputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    SmartPointer                    _deflater;              
  public:
    virtual void  flush()
      throw(IOException*);

    virtual void  write( DByte[] , DULong size )
      throw(Exception*);

    virtual void  close()
      throw(IOException*);
  public :
    DeflaterOutputStream( OutputStream * _outputStream , 
			  Deflater     * _deflater );
    DeflaterOutputStream( const DeflaterOutputStream& right );
    ~DeflaterOutputStream();
  public:    
    DeflaterOutputStream& operator   =(const DeflaterOutputStream & right );
  };
  inline void   DeflaterOutputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("OutputStream");
    _parentClasses.insert("FilterOutputStream");
  }
  inline void   DeflaterOutputStream::_setType()
  {
    this -> _type = "DeflaterOutputStream";
  }
}
#endif
