#include <System/IO/DAQBuilderFile.hh>
#include <System/DAQBuilderTimestamp.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
    void                     File::_finalize()
    {
        this->close();
        _fileName.clear();
    }
    const  DString           File::toString() const 
    {
      DString aString ;//= _toStringHeader();
      aString        += "FileName       : ";
      aString        += _fileName;
      aString        += "\n";
      aString        += "FileDescriptor : ";
      aString        += String::digitToString((DLong)_fd);
      aString        += "\n";
      if(isExists())
      {
	aString        += "isDirectory    : ";
	aString        += isDirectory() ? "true" : "false";
	aString        += "\n";
	aString        += "isFile         : ";
	aString        += isFile() ? "true" : "false";
	aString        += "\n";
	aString        += "lastModified   : ";
	aString        += Timestamp(lastModified()*1000).toString();
	aString        += "\n";
	aString        += "Length         : ";
	aString        += String::digitToString((DULong)getLength());
	aString        += "\n";
      }
      //aString += _toStringFooter();
      return aString;
    }
     /*DByte            File::compareTo( const File&    f)
     {
     }
     DByte            File::compareTo( const Object * o);
     */
     void File::makeDirectory( mode_t mode )
                         throw (IOException *)
     {
       if(isExists())
	 {
	   IOException * e = new IOException("File "+_fileName+" isExists");
	   DString aLocation ="File::makeDirectory(mode_t)";
	   aLocation        += __LINE__;
	   e -> insert("Location",aLocation);
	   throw e;
	 }
       _fd=::mkdir( _fileName.c_str() , mode );
       if(!isOpen()) 
	 {
	   IOException * e = new IOException(strerror(errno));
	   DString aLocation ="File::createNewFile(mode_t)";
	   aLocation        += __LINE__;
	   e -> insert("Location",aLocation);
	   throw e;
	 }
     }
  void             File::createNewFile( mode_t mode )
    throw (IOException *)
  {
    if(isExists())
      {
	IOException * e = new IOException("File "+_fileName+" isExists");
	DString aLocation ="File::createNewFile(mode_t)";
	aLocation        += __LINE__;
	e -> insert("Location",aLocation);
	throw e;
      }
    _fd=::creat( _fileName.c_str() , mode );
    if(!isOpen()) 
      {
	IOException * e = new IOException( ::strerror(errno));
	DString aLocation ="File::createNewFile(mode_t)";
	aLocation        += __LINE__;
	e -> insert("Location",aLocation);
	throw e;
      }
    
  }
  File             File::createTempFile( const DString& fileName , mode_t mode )
    throw (IOException *)
  {
    File aFile(fileName);
    aFile.createNewFile();
    return aFile;       
  }
  void             File::remove()
    throw (IOException *)
  {
    if(!isExists())
      {
	IOException * e = new IOException( "File "+_fileName+" isn't Exists");
	DString aLocation ="File::remove()";
	aLocation        += __LINE__;
	e -> insert("Location",aLocation);
	throw e;
      }
    if(isFile())
      {
	if(::unlink( _fileName.c_str() )!=0)
	  {
	    IOException * e = new IOException( ::strerror(errno) );
	    DString aLocation ="File::remove()";
	    aLocation        += __LINE__;
	    e -> insert("Location",aLocation);
	    throw e;
	  }
      } 
    else if(isDirectory())
      {
	if(::rmdir( _fileName.c_str() )!=0)
	  {
	    IOException * e = new IOException( ::strerror(errno) );
	    DString aLocation ="File::remove()";
	    aLocation        += __LINE__;
	    e -> insert("Location",aLocation);
	    throw e;
	  }
      } 
  }
  DBool            File::equals( const Object * o )
  {
    if(equalTypes(o))
      {
	DBool aRet  = ( _fileName == ((File*)o)->_fileName );
	aRet       |= ( _fd       == ((File*)o)->_fd);
	return aRet;
      }
    return false;
  }
  DBool            File::equals( const File&    f )
  {
    return equals((Object*)&f);
  }
  const DString&   File::getName() const 
  {
    return _fileName;
  }
  DBool            File::isExists() const 
  {
    return ::access(_fileName.c_str(),F_OK)==0;
  }
  DBool            File::isDirectory() const 
  {
    struct stat aStat ; 
    ::bzero(&aStat, sizeof(aStat));
    if(::stat(_fileName.c_str(),&aStat)!=0) 
      return false;
    return S_ISDIR(aStat.st_mode) ;
  }
  DBool            File::isFile() const 
  {
    struct stat aStat ; 
    ::bzero(&aStat, sizeof(aStat));
    if(::stat(_fileName.c_str(),&aStat)!=0) 
      return false;
    return S_ISREG(aStat.st_mode);
  }
  
  DULong           File::lastModified() const 
  {
    struct stat aStat ; 
    ::bzero(&aStat, sizeof(aStat));
    if(::stat(_fileName.c_str(),&aStat)!=0) 
      return 0;
    return aStat.st_mtime;
  }
  DULong           File::getLength() const 
  {
    struct stat aStat ; 
    ::bzero(&aStat, sizeof(aStat));
    if(::stat(_fileName.c_str(),&aStat)!=0) 
      return 0;
    return aStat.st_size;
  }

  StringList       File::list() const
  {
    StringList aStringList;
    struct dirent **namelist;
    DInt n  = scandir(_fileName.c_str(), &namelist, 0, alphasort);
    if (n < 0){
      return aStringList;
    }
    else {
      while(n--) {
	aStringList.push_back(namelist[n]->d_name);
	free(namelist[n]);
      }
      free(namelist);
    }
    return aStringList;
  }
   
  std::vector<File>       File::listFile() const
  {
    StringList aStringList = list();
    std::vector<File> aFileList ;
    for( StringList::const_iterator iter  = aStringList.begin();
                                    iter != aStringList.end();
                                    iter++)
     {
         aFileList.push_back( File(_fileName+(*iter)) ); 
     }
    return aFileList;
  }
  void             File::close()
    throw (IOException *)
  {
    if(isOpen()&& !_cancopy) 
      {
	if(::close(_fd)!=0)
	  {
	    IOException * e = new IOException( ::strerror(errno));
	    DString aLocation ="File::close()";
	    aLocation        += __LINE__;
	    e -> insert("Location",aLocation);
	    throw e;
	  }
      }
    _fd = -1;
  }
  void             File::open( DInt flag ) 
    throw (IOException *)
  {
    if(!isOpen())
      {
	_fd = ::open( _fileName.c_str(),flag);
	if(!isOpen())
	  {
	    IOException * e = new IOException( ::strerror(errno));
	    DString aLocation ="File::open(DInt)";
	    aLocation        += __LINE__;
	    e -> insert("Location",aLocation);
	    throw e;
	  }
      }
  } 
  void             File::openRead() 
    throw (IOException *)
  {
    this -> open( O_RDONLY ); 
  } 
  void             File::openWrite() 
    throw (IOException *)
  {
    this -> open( O_WRONLY |  O_TRUNC ); 
  } 
  void             File::openAppend() 
    throw (IOException *)
  {
    this -> open( O_RDWR |  O_APPEND );
  } 
  void             File::openReadWrite() 
    throw (IOException *)
  {
    this -> open( O_RDWR );
  } 
  inline DBool            File::isOpen() const 
  {
    return (_fd >= 0 ) ? true : false ;
  } 
 void            File::synchronize()
               throw( IOException * )
  {
      if(fsync(_fd==-1)){
	   IOException * e = new IOException( ::strerror(errno));
	   DString aLocation ="File::open(DInt)";
	   e -> insert("Location",aLocation);
	   throw e;
      }
  }
 void            File::dataSynchronize()
               throw( IOException * )
  {
      if(fdatasync(_fd==-1)){
	   IOException * e = new IOException( ::strerror(errno));
	   DString aLocation ="File::open(DInt)";
	   e -> insert("Location",aLocation);
	   throw e;
      }
  }
  
  File::File( const DString& fileName )
    :Object(),_fileName(fileName),_fd(-1),_cancopy(false)
  {
    _setType();
    _setParentClasses();
  }
  void                            File::_setCancopy()
  {
    _cancopy=true;
  }
  void                            File::_unSetCancopy()
  {
    _cancopy=false;
  }
  
  File::File( const File& right )
    :Object( *((Object*)&right) ),_fileName(right._fileName),
     _fd(-1),_cancopy(right._cancopy)
  {
    _setType();
    _setParentClasses();
    if(right._cancopy)
      _fd=right._fd;
  }
  File::~File()
  {
    _finalize();
  }
  File& File::operator=(const File & right )
  {
    *((Object*)this) =  *((Object*)&right);
    _finalize();
    _fileName        = right._fileName;
    _cancopy         = right._cancopy;
    _fd =1;
    if(right._cancopy)
      _fd=right._fd;
    return *this;
  }
}
