#ifndef __DAQBuilderFile_HH__
#define __DAQBuilderFile_HH__ 
#include <DAQBuilderObject.hh>
#include <Interface/DAQBuilderComparable.hh>
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class FileInputStream;
  class FileOutputStream;
  class StandardOutput;
  class StandardError;
  class StandardInput;
  class File : public Object //: public Comparable
  {
  friend class FileInputStream;
  friend class FileOutputStream;
  friend class StandardOutput;
  friend class StandardError;
  friend class StandardInput;
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    DString                         _fileName;
    FileDescriptor                  _fd;
    DBool                           _cancopy;
  protected:
    void                            _setCancopy();
    void                            _unSetCancopy();
  public:
    //virtual DByte            compareTo( const File&    f);
    //virtual DByte            compareTo( const Object * o);
    virtual DBool            equals( const Object * o );
    virtual DBool            equals( const File&    f );

    virtual void             createNewFile( mode_t mode = 0644)
      throw (IOException *);
    static  File             createTempFile( const DString& fileName ,mode_t mode = 0644 )
      throw (IOException *);
    virtual void             remove()
      throw (IOException *);
    virtual DBool            isExists() const ;
    virtual const DString&   getName() const ;
    virtual DBool            isDirectory() const ;
    virtual DBool            isFile() const ;
    virtual DULong           lastModified() const ;
    virtual DULong           getLength() const ;
    virtual void             makeDirectory( mode_t mode = 0744)
      throw (IOException *);

    virtual StringList        list() const;
    virtual std::vector<File> listFile() const;
 
    virtual void             open( DInt flags )
               throw( IOException * );
    virtual void             openRead()
               throw( IOException * );
    virtual void             openWrite()
               throw( IOException * );
    virtual void             openReadWrite()
               throw( IOException * );
    virtual void             openAppend()
               throw( IOException * );
    virtual DBool            isOpen() const ;
    virtual void             close()
               throw( IOException * );
    virtual void             synchronize()
               throw( IOException * );
    virtual void             dataSynchronize()
               throw( IOException * );
  public :
    File( const DString& fileName );
    File( const File& right );
    ~File();
  public:    
    File& operator   =(const File & right );
  };
  inline void   File::_setParentClasses()
  {
    _parentClasses.insert("Object");
    //_parentClasses.insert("Comparable");
  }
  inline void   File::_setType()
  {
    this -> _type = "File";
  }
}
#endif
