#include <System/IO/DAQBuilderFileInputStream.hh>
#include <System/DAQBuilderTimestamp.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            FileInputStream::_finalize()
  {
//    _file._finalize();
    _currentPosition=0;
    _markedPosition =-1;
  }

  const  DString                  FileInputStream::toString() const 
  {
    DString aString ;//= _toStringHeader();
    aString        += "FileName       : ";
    aString        += _file._fileName;
    aString        += "\n";
    aString        += "FileDescriptor : ";
    aString        += String::digitToString((DLong)_file._fd);
    aString        += "\n";
    if(_file.isExists())
      {
	aString        += "isDirectory    : ";
	aString        += _file.isDirectory() ? "true" : "false";
	aString        += "\n";
	aString        += "isFile         : ";
	aString        += _file.isFile() ? "true" : "false";
	aString        += "\n";
	aString        += "lastModified   : ";
	aString        += Timestamp(_file.lastModified()*1000).toString();
	aString        += "\n";
	aString        += "Length         : ";
	aString        += String::digitToString((DULong)_file.getLength());
	aString        += "\n";
	aString        += "AvailableSize  : ";
	aString        += String::digitToString((DULong)available());
	aString        += "\n";
      }
    aString        += "CurrentPosition  : ";
    aString        += String::digitToString((DLong)_currentPosition);
    aString        += "\n";
    aString        += "MarkedPosition   : ";
    aString        += String::digitToString((DLong)_markedPosition);
    aString        += "\n";
    //aString += _toStringFooter();
    return aString;
  }

  void  FileInputStream::mark()
  {
    if(!_file.isOpen())
      {
        try{
	_file.openRead();
	}catch(IOException *e ){
	  deleteObject((Object*)e);
	}
      }
    _markedPosition = ::lseek(_file._fd,0,SEEK_CUR);
  }
  DBool FileInputStream::markSupported()
  {
    return true;
  }

  DULong FileInputStream::available() const 
  {
    DULong aULong =  _file.getLength() -  _currentPosition;
    return aULong;
  }
  DULong  FileInputStream::read( DByte* buffer , DULong size )
    throw(Exception*)
  {
    if(!_file.isOpen())
      _file.openRead();

    //std::cout<<"_file"<<std::endl;
    //std::cout<<&_file<<std::endl;
    DULong   aRemainSize = size;
    while( aRemainSize > 0 )
      {
	ssize_t aTmpReadSize = ::read( _file._fd , (void*)buffer, aRemainSize );
        if( aTmpReadSize < 0 )
	  {
            if( errno != EINTR)
	      {
		IOException * e = new IOException(strerror(errno));
		DString aLocation ="FileInputStream::read(DByte[],DULong)";
		aLocation        += __LINE__;
		e -> insert("Location",aLocation);
		throw e;
	      }
            aTmpReadSize=0;
	  }
        else if(aTmpReadSize == 0){
            _isEOF = true;
            break;
        }
	aRemainSize -= aTmpReadSize;
      }
    _currentPosition = ::lseek(_file._fd,0,SEEK_CUR);
    return size - aRemainSize; 
  }
  void  FileInputStream::reset()                      
    throw(IOException*)
  {
    if(!_file.isOpen())
	_file.openRead();
    if(::lseek(_file._fd,_markedPosition,SEEK_SET)==-1)
      {
	IOException * e = new IOException(strerror(errno));
	DString aLocation ="FileInputStream::reset()";
	aLocation        += __LINE__;
	e -> insert("Location",aLocation);
	throw e;
      }
     _isEOF = false;
  }
  DLong FileInputStream::skip( DLong     nSkip)       
    throw(IOException*)
  {
    if(!_file.isOpen())
      _file.openRead();
    DLong aSkip=::lseek(_file._fd,off_t(nSkip),SEEK_CUR);
    if( aSkip==-1)
      {
	IOException * e = new IOException(strerror(errno));
	DString aLocation ="FileInputStream::skip(DLong)";
	aLocation        += __LINE__;
	e -> insert("Location",aLocation);
	throw e;
      }
    return aSkip;
  }
  void  FileInputStream::close()
    throw(IOException*)
  {
    _file.close();
  }
  FileInputStream::FileInputStream( const DString& fileName )
      throw(FileNotFoundException*)
    :InputStream(),_file( File(fileName )),
     _currentPosition(0),_markedPosition(-1)
  {
    _setType();
    _setParentClasses();
    if(!_file.isExists())
    {
      FileNotFoundException * e = new FileNotFoundException("File "+_file.getName()+" isn't Exists"); 
      DString aLocation = "FileInputStream::FileInputStream(const DString&)";
      aLocation        += __LINE__;
      e->insert("Location",aLocation);
    }
    //std::cout<<"Check"<<std::endl; 
  }
  FileInputStream::FileInputStream( const File& file )
      throw(FileNotFoundException*)
    :InputStream(),_file(file),
     _currentPosition(0),_markedPosition(-1)
  {
    _setType();
    _setParentClasses();
    //std::cout<<"file"<<std::endl;
    //std::cout<<&file<<std::endl;
    if(!_file.isExists())
    {
      FileNotFoundException * e = new FileNotFoundException("File "+_file.getName()+" isn't Exists"); 
      DString aLocation = "FileInputStream::FileInputStream(const File&)";
      aLocation        += __LINE__;
      e->insert("Location",aLocation);
    }
  }
  FileInputStream::FileInputStream( const FileInputStream& right ) 
      throw(FileNotFoundException*)
    :InputStream(*((InputStream*)&right)),_file(right._file),
     _currentPosition(right._currentPosition),_markedPosition(right._markedPosition)
  {
    //*((Object*)this) =       *((Object*)&right);
    _setType();
    _setParentClasses();
    if(!_file.isExists())
    {
      FileNotFoundException * e = new FileNotFoundException("File "+_file.getName()+" isn't Exists"); 
      DString aLocation = "FileInputStream::FileInputStream(const FileInputStream&)";
      aLocation        += __LINE__;
      e->insert("Location",aLocation);
    }
    if(!_file.isOpen())
      {
        try{
	_file.openRead();
	}catch(IOException * e){
          deleteObject((Object*)e);
	}
      }
    ::lseek(_file._fd,_currentPosition,SEEK_SET);
  }
  FileInputStream::~FileInputStream()
  {
    _finalize();
  }
  FileInputStream& FileInputStream::operator   =(const FileInputStream & right )
  {
    *((InputStream*)this) =       *((InputStream*)&right);
    _file = right._file;
    _currentPosition = right._currentPosition;
    _markedPosition  = right._markedPosition;
    if(!_file.isOpen())
      {
        try{
	_file.openRead();
	}catch(IOException * e){
          deleteObject((Object*)e);
	}
      }
    ::lseek(_file._fd,_currentPosition,SEEK_SET);
    return *this;
  }
}
