#ifndef __DAQBuilderFileInputStream_HH__
#define __DAQBuilderFileInputStream_HH__
#include <System/IO/DAQBuilderInputStream.hh>
#include <System/IO/DAQBuilderFile.hh>
#include <Exception/DAQBuilderIOException.hh>
#include <Exception/DAQBuilderFileNotFoundException.hh>

namespace DAQBuilder
{
  class FileInputStream : public InputStream
  {
  protected:
    void                            _setType();
    void                            _setParentClasses();
    void                            _finalize();
  public:
    const  DString                  toString() const ;
  protected:
    File                            _file;
    DInt                            _currentPosition;
    DInt                            _markedPosition;
  public:
    virtual DULong available() const ;
    virtual void  mark();
    virtual DBool markSupported();
    virtual DULong  read( DByte[] , DULong size )
      throw(Exception*);
    virtual void  reset()                      
      throw(IOException*);
    virtual DLong skip( DLong     nSkip)       
      throw(IOException*);
    virtual void  close()
      throw(IOException*);
  public :
    FileInputStream( const DString& fileName )
      throw(FileNotFoundException*);
    FileInputStream( const File& _file )
      throw(FileNotFoundException*);
    FileInputStream( const FileInputStream& right )
      throw(FileNotFoundException*);
    ~FileInputStream();
  public:    
    FileInputStream& operator   =(const FileInputStream & right );
  };
  inline void   FileInputStream::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("InputStream");
  }
  inline void   FileInputStream::_setType()
  {
    this -> _type = "FileInputStream";
  }
}
#endif
