#include <System/IO/DAQBuilderFileOutputStream.hh>
#include <System/DAQBuilderTimestamp.hh>
#include <Primitives/DAQBuilderString.hh>

namespace DAQBuilder
{
  void                            FileOutputStream::_open()
  {
    if(_append==true)
      _file.openAppend();
    else
      _file.openWrite();
  }
  void                            FileOutputStream::_finalize()
  {
    _append = false ;
  }

  const  DString                  FileOutputStream::toString() const 
  {
    FileDescriptor fd = _file._fd;
    DString aString ;//= _toStringHeader();
    aString        += "FileName       : ";
    aString        += _file._fileName;
    aString        += "\n";
    aString        += "FileDescriptor : ";
    aString        += String::digitToString((DLong)fd);
    aString        += "\n";
    if(_file.isExists())
      {
	aString        += "isDirectory    : ";
	aString        += _file.isDirectory() ? "true" : "false";
	aString        += "\n";
	aString        += "isFile         : ";
	aString        += _file.isFile() ? "true" : "false";
	aString        += "\n";
	aString        += "lastModified   : ";
	aString        += Timestamp(_file.lastModified()*1000).toString();
	aString        += "\n";
	aString        += "Length         : ";
	aString        += String::digitToString((DULong)_file.getLength());
	aString        += "\n";
      }
    aString        += "isAppend    : ";
    aString        += _append ? "true" : "false";
    aString        += "\n";
    //aString += _toStringFooter();
    return aString;
  }

  void  FileOutputStream::flush()
    throw(IOException * )
  {;}
  
  void  FileOutputStream::write( DByte* buffer , DULong size )
    throw(Exception*)
  {
    if(!_file.isOpen())
      _open();

    DULong   aRemainSize = size;
    FileDescriptor fd = _file._fd;
    while( aRemainSize > 0 )
      {
	ssize_t aTmpReadSize = ::write( fd , (void*)buffer, aRemainSize );
        if( aTmpReadSize < 0 )
	  {
            if( errno != EINTR)
	      {
		IOException * e = new IOException(strerror(errno));
		DString aLocation ="FileOutputStream::write(DByte[],DULong)";
		aLocation        += __LINE__;
		e -> insert("Location",aLocation);
		e -> insert("Dump    ",toString());
		throw e;
	      }
            aTmpReadSize=0;
	  }
        else if(aTmpReadSize == 0)
            break;
	aRemainSize -= aTmpReadSize;
      }
    /*std::cout<<"&_file"<<std::endl;
    std::cout<<&_file<<std::endl;
*/
  }
  void  FileOutputStream::close()
    throw(IOException*)
  {
    _file.close();
  }
  FileOutputStream::FileOutputStream( const DString& fileName , DBool append )
        throw(FileNotFoundException * )
    :OutputStream(),_file( File(fileName )),
     _append(append)
  {
    _setType();
    _setParentClasses();
    if(!_file.isExists())
    {
      FileNotFoundException * e = new FileNotFoundException("File "+_file.getName()+" isn't Exists"); 
      DString aLocation = "FileOutputStream::FileOutputStream(const DString&,DBool)";
      aLocation        += __LINE__;
      e->insert("Location",aLocation);
    }
  }
  FileOutputStream::FileOutputStream( const File& file , DBool append )
        throw(FileNotFoundException * )
    :OutputStream(),_file(file),
     _append(append)
  {
    _setType();
    _setParentClasses();
    if(!_file.isExists())
    {
      FileNotFoundException * e = new FileNotFoundException("File "+_file.getName()+" isn't Exists"); 
      DString aLocation = "FileOutputStream::FileOutputStream(const File&, DBool)";
      aLocation        += __LINE__;
      e->insert("Location",aLocation);
    }
 /*   std::cout<<"&file"<<std::endl;
    std::cout<<&file<<std::endl;
*/
  }
  FileOutputStream::FileOutputStream( const FileOutputStream& right )
        throw(FileNotFoundException * )
    :OutputStream(*((OutputStream*)&right)),_file(right._file),
     _append(right._append)
  {
    //*((Object*)this) =       *((Object*)&right);
    _setType();
    _setParentClasses();
    if(!_file.isExists())
    {
      FileNotFoundException * e = new FileNotFoundException("File "+_file.getName()+" isn't Exists"); 
      DString aLocation = "FileOutputStream::FileOutputStream(const &FileOutputStream)";
      aLocation        += __LINE__;
      e->insert("Location",aLocation);
    }
  }
  FileOutputStream::~FileOutputStream()
  {
    _finalize();
  }
  FileOutputStream& FileOutputStream::operator   =(const FileOutputStream & right )
  {
    *((OutputStream*)this) =       *((OutputStream*)&right);
    _file = right._file;
    _append  = right._append;
    return *this;
  }
}
